/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.activity;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.dmz.notification.Notification;
import com.atlassian.bitbucket.dmz.notification.NotificationHandler;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestActivityNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestUpdatedNotification;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestAutoMergeCancelledActivity;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.bitbucket.pull.PullRequestDraftStatusUpdatedActivity;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.bitbucket.pull.PullRequestRescopeActivity;
import com.atlassian.bitbucket.pull.PullRequestReviewersUpdatedActivity;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.watcher.WatchableVisitor;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.notification.NotificationConstants;
import com.atlassian.stash.internal.notification.batch.Data;
import com.atlassian.stash.internal.notification.batch.dao.UserNotificationDao;
import com.atlassian.stash.internal.notification.handlers.NotificationHelper;
import com.atlassian.stash.internal.notification.mention.MentionHelper;
import com.atlassian.stash.internal.notification.pull.activity.ActivityData;
import com.atlassian.stash.internal.notification.pull.activity.CommentData;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestBatchId;
import com.atlassian.stash.internal.notification.pull.activity.ToBranchUpdateData;
import com.atlassian.stash.internal.notification.repository.IsRepositoryWatchableVisitor;
import com.atlassian.stash.internal.notification.repository.handler.RepositoryNotificationRecipientHelper;
import com.atlassian.stash.internal.notification.repository.handler.RepositoryNotificationSettingsFilterParameters;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestBatchNotificationHandler
implements NotificationHandler<PullRequestNotification> {
    private static final Logger log = LoggerFactory.getLogger(PullRequestBatchNotificationHandler.class);
    private final MentionHelper mentionHelper;
    private final UserNotificationDao notificationDao;
    private final NotificationHelper notificationHelper;
    private final RepositoryNotificationRecipientHelper repositoryNotificationRecipientHelper;
    private final TransactionTemplate transactionTemplate;
    private final MailService mailService;

    public PullRequestBatchNotificationHandler(MailService mailService, MentionHelper mentionHelper, UserNotificationDao notificationDao, NotificationHelper notificationHelper, RepositoryNotificationRecipientHelper repositoryNotificationRecipientHelper, TransactionTemplate transactionTemplate) {
        this.mailService = mailService;
        this.mentionHelper = mentionHelper;
        this.notificationDao = notificationDao;
        this.notificationHelper = notificationHelper;
        this.repositoryNotificationRecipientHelper = repositoryNotificationRecipientHelper;
        this.transactionTemplate = transactionTemplate;
    }

    public void handle(@Nonnull PullRequestNotification notification, @Nonnull Set<Watcher> watchers) {
        if (!this.mailService.isHostConfigured()) {
            log.debug("No mail configuration: discarding {} details: {}", (Object)notification.getClass().getSimpleName(), (Object)notification);
            return;
        }
        if (notification instanceof PullRequestActivityNotification) {
            this.handleActivity((PullRequestActivityNotification)notification, watchers);
        } else if (notification instanceof PullRequestUpdatedNotification) {
            this.handleUpdatedNotification((PullRequestUpdatedNotification)notification, watchers);
        }
    }

    private void handleUpdatedNotification(PullRequestUpdatedNotification notification, Set<Watcher> watchers) {
        if (notification.getPreviousToBranch() == null) {
            return;
        }
        PullRequest pullRequest = notification.getPullRequest();
        Date timestamp = notification.getTimestamp();
        this.enqueueNotification(pullRequest, watchers, timestamp, new ToBranchUpdateData(notification.getUser().getId(), pullRequest.getToRef().getDisplayId(), timestamp));
    }

    private void handleActivity(final PullRequestActivityNotification notification, final Set<Watcher> watchers) {
        PullRequestActivity activity = notification.getActivity();
        final PullRequest pullRequest = activity.getPullRequest();
        activity.accept(new PullRequestActivityVisitor(){

            public void visit(@Nonnull PullRequestActivity activity) {
                switch (activity.getAction()) {
                    case OPENED: {
                        Set repositoryWatchers = (Set)watchers.stream().filter(watcher -> (Boolean)watcher.getWatchable().accept((WatchableVisitor)new IsRepositoryWatchableVisitor())).collect(MoreCollectors.toImmutableSet());
                        PullRequestBatchNotificationHandler.this.enqueueActivityNotification(pullRequest, repositoryWatchers, activity.getCreatedDate(), activity);
                        break;
                    }
                    case UPDATED: {
                        break;
                    }
                    case REVIEWED: {
                        ApplicationUser author = activity.getPullRequest().getAuthor().getUser();
                        PullRequestBatchNotificationHandler.findWatcher(watchers, author).ifPresent(watcher -> PullRequestBatchNotificationHandler.this.enqueueNotification(pullRequest, Collections.singleton(watcher), notification.getTimestamp(), new ActivityData(activity.getId())));
                        break;
                    }
                    default: {
                        PullRequestBatchNotificationHandler.this.enqueueActivityNotification(pullRequest, watchers, activity.getCreatedDate(), activity);
                    }
                }
            }

            public void visit(@Nonnull PullRequestCommentActivity activity) {
                CommentAction action = activity.getCommentAction();
                if (action == CommentAction.ADDED || action == CommentAction.REPLIED) {
                    Comment comment = activity.getComment();
                    Set<ApplicationUser> mentionedUsers = PullRequestBatchNotificationHandler.this.mentionHelper.findUsers((Notification)notification, comment.getText());
                    Set notMentioned = (Set)watchers.stream().filter(watcher -> !mentionedUsers.contains(watcher.getUser())).collect(MoreCollectors.toImmutableSet());
                    CommentData data = new CommentData(comment);
                    Date timestamp = activity.getCreatedDate();
                    PullRequestBatchNotificationHandler.this.enqueuePullRequestNotification(PullRequestBatchId.of(pullRequest).encode(), mentionedUsers, activity.getCreatedDate(), data);
                    PullRequestBatchNotificationHandler.this.enqueueNotification(pullRequest, notMentioned, timestamp, data);
                }
            }

            public void visit(@Nonnull PullRequestDraftStatusUpdatedActivity activity) {
                PullRequestBatchNotificationHandler.this.enqueueActivityNotification(pullRequest, watchers, activity.getCreatedDate(), (PullRequestActivity)activity);
            }

            public void visit(@Nonnull PullRequestMergeActivity activity) {
                PullRequestBatchNotificationHandler.this.enqueueActivityNotification(pullRequest, watchers, activity.getCreatedDate(), (PullRequestActivity)activity);
            }

            public void visit(@Nonnull PullRequestRescopeActivity activity) {
                if (activity.getFromHash().equals(activity.getPreviousFromHash())) {
                    return;
                }
                PullRequestBatchNotificationHandler.this.enqueueActivityNotification(pullRequest, watchers, activity.getCreatedDate(), (PullRequestActivity)activity);
            }

            public void visit(@Nonnull PullRequestReviewersUpdatedActivity activity) {
                ApplicationUser author = pullRequest.getAuthor().getUser();
                if (activity.getUser().equals((Object)author)) {
                    return;
                }
                PullRequestBatchNotificationHandler.findWatcher(watchers, author).ifPresent(watcher -> PullRequestBatchNotificationHandler.this.enqueueNotification(pullRequest, Collections.singleton(watcher), notification.getTimestamp(), new ActivityData(activity.getId())));
            }

            public void visit(@Nonnull PullRequestAutoMergeCancelledActivity activity) {
                PullRequestBatchNotificationHandler.this.enqueueActivityNotification(pullRequest, watchers, activity.getCreatedDate(), (PullRequestActivity)activity);
            }
        });
    }

    private static Optional<Watcher> findWatcher(Set<Watcher> watchers, ApplicationUser user) {
        return watchers.stream().filter(watcher -> watcher.getUser().equals((Object)user)).findFirst();
    }

    private void enqueueActivityNotification(PullRequest pullRequest, Set<Watcher> watchers, Date timestamp, PullRequestActivity activity) {
        EnumSet<PullRequestNotificationScope> interested = EnumSet.of(PullRequestNotificationScope.ALL);
        if (NotificationConstants.STATE_CHANGE_ACTIONS.contains(activity.getAction())) {
            interested.add(PullRequestNotificationScope.STATE_CHANGES);
        }
        this.enqueueNotification(pullRequest, watchers, timestamp, new ActivityData(activity.getId()), interested);
    }

    private void enqueueNotification(PullRequest pullRequest, Set<Watcher> watchers, Date timestamp, Data notificationData) {
        this.enqueueNotification(pullRequest, watchers, timestamp, notificationData, EnumSet.of(PullRequestNotificationScope.ALL));
    }

    private void enqueueNotification(PullRequest pullRequest, Set<Watcher> watchers, Date timestamp, Data notificationData, Set<PullRequestNotificationScope> interestedScopes) {
        final HashSet<Watcher> repositoryWatchers = new HashSet<Watcher>();
        final HashSet<ApplicationUser> pullRequestWatchers = new HashSet<ApplicationUser>();
        watchers.forEach(watcher -> watcher.getWatchable().accept((WatchableVisitor)new WatchableVisitor<Void>(){

            public Void visit(@Nonnull CommitDiscussion discussion) {
                return null;
            }

            public Void visit(@Nonnull PullRequest pullRequest) {
                pullRequestWatchers.add(watcher.getUser());
                return null;
            }

            public Void visit(@Nonnull Repository repository) {
                repositoryWatchers.add(watcher);
                return null;
            }
        }));
        String pullRequestBatchId = PullRequestBatchId.of(pullRequest).encode();
        this.enqueueRepositoryNotification(pullRequest, timestamp, notificationData, interestedScopes, repositoryWatchers, pullRequestBatchId);
        this.enqueuePullRequestNotification(pullRequestBatchId, pullRequestWatchers, timestamp, notificationData);
    }

    private void enqueueRepositoryNotification(PullRequest pullRequest, Date timestamp, Data notificationData, Set<PullRequestNotificationScope> interestedScopes, Set<Watcher> repositoryWatchers, String pullRequestBatchId) {
        Set<ApplicationUser> filteredRepositoryWatchers = this.filterRepositoryWatchers(pullRequest, interestedScopes, repositoryWatchers);
        this.persistNotification("Repository", pullRequestBatchId, filteredRepositoryWatchers, timestamp, notificationData);
    }

    private void enqueuePullRequestNotification(String batchId, Set<ApplicationUser> recipients, Date timestamp, Data notificationData) {
        Set<ApplicationUser> filteredPullRequestWatchers = this.notificationHelper.filterByPullRequestSendMode(recipients, SendMode.batchedSet());
        this.persistNotification("PullRequest", batchId, filteredPullRequestWatchers, timestamp, notificationData);
    }

    private Set<ApplicationUser> filterRepositoryWatchers(PullRequest pullRequest, Set<PullRequestNotificationScope> interestedScopes, Set<Watcher> repositoryWatchers) {
        if (repositoryWatchers.isEmpty()) {
            return new HashSet<ApplicationUser>();
        }
        RepositoryNotificationSettingsFilterParameters filterParameters = new RepositoryNotificationSettingsFilterParameters.Builder(pullRequest.getToRef().getRepository()).pullRequestNotificationScopes(interestedScopes).sendMode(SendMode.BATCHED).watchers(repositoryWatchers).build();
        return (Set)this.repositoryNotificationRecipientHelper.findSettings(filterParameters).stream().map(RepositoryNotificationSettings::getUser).collect(MoreCollectors.toImmutableSet());
    }

    private void persistNotification(String senderId, String batchId, Set<ApplicationUser> recipients, Date timestamp, Data notificationData) {
        String encodedData;
        if (recipients.isEmpty()) {
            return;
        }
        try {
            encodedData = notificationData.encode();
        }
        catch (IOException e) {
            log.error("Failed to encode notification data: {}", (Object)notificationData);
            return;
        }
        recipients.forEach(recipient -> this.transactionTemplate.execute(() -> this.notificationDao.create(recipient.getId(), timestamp, senderId, batchId, encodedData)));
    }
}

