/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.activity;

import com.atlassian.bitbucket.dmz.notification.pull.custom.CustomNotificationData;
import com.atlassian.bitbucket.dmz.notification.pull.custom.CustomNotificationSection;
import com.atlassian.bitbucket.dmz.notification.pull.custom.CustomPullRequestNotificationRenderer;
import com.atlassian.bitbucket.mail.MailException;
import com.atlassian.bitbucket.mail.MailQueueFullException;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatcherSearchRequest;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.stash.internal.notification.batch.BatchNotificationAccumulator;
import com.atlassian.stash.internal.notification.batch.BatchSender;
import com.atlassian.stash.internal.notification.batch.BatchUtils;
import com.atlassian.stash.internal.notification.batch.Data;
import com.atlassian.stash.internal.notification.batch.PullRequestBatchNotificationAccumulator;
import com.atlassian.stash.internal.notification.batch.dao.UserNotification;
import com.atlassian.stash.internal.notification.custom.pull.CustomPullRequestNotificationRendererAccessor;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestActivityRenderContext;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestActivityRenderer;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestBatchData;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestBatchDataLoader;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestBatchId;
import com.atlassian.stash.internal.notification.pull.activity.ToBranchUpdate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestBatchSender
implements BatchSender {
    public static final String ID = "PullRequest";
    private static final Set<PullRequestAction> ACTIONS_TO_INCLUDE_IN_PR_BATCH_EMAILS = Sets.immutableEnumSet((Enum)PullRequestAction.APPROVED, (Enum[])new PullRequestAction[]{PullRequestAction.REVIEWED, PullRequestAction.UNAPPROVED, PullRequestAction.REOPENED, PullRequestAction.DECLINED, PullRequestAction.UPDATED, PullRequestAction.AUTO_MERGE_CANCELLED, PullRequestAction.AUTO_MERGE_REQUESTED});
    private static final int DEFAULT_PAGE_SIZE = 25;
    private static final int MAX_PULL_REQUEST_ACTIVITIES_SHOWN = 50;
    private static final Logger log = LoggerFactory.getLogger(PullRequestBatchSender.class);
    private final MailService mailService;
    private final PermissionService permissionService;
    private final CustomPullRequestNotificationRendererAccessor customRendererAccessor;
    private final PullRequestActivityRenderer renderer;
    private final PullRequestBatchDataLoader dataLoader;
    private final WatcherService watcherService;

    public PullRequestBatchSender(MailService mailService, PermissionService permissionService, CustomPullRequestNotificationRendererAccessor customRendererAccessor, PullRequestActivityRenderer renderer, PullRequestBatchDataLoader dataLoader, WatcherService watcherService) {
        this.customRendererAccessor = customRendererAccessor;
        this.dataLoader = dataLoader;
        this.mailService = mailService;
        this.permissionService = permissionService;
        this.renderer = renderer;
        this.watcherService = watcherService;
    }

    @Override
    public BatchNotificationAccumulator createAccumulator(@Nonnull BatchNotificationAccumulator.Callback callback) {
        return new PullRequestBatchNotificationAccumulator(callback);
    }

    @Override
    @Nonnull
    public String getId() {
        return ID;
    }

    @Override
    public boolean send(@Nonnull String batchIdString, @Nonnull ApplicationUser user, @Nonnull Set<UserNotification> notifications) {
        if (!this.mailService.isHostConfigured()) {
            return false;
        }
        PullRequest pullRequest = this.getPullRequest(batchIdString);
        if (pullRequest == null) {
            return true;
        }
        return this.send(pullRequest, user, notifications);
    }

    private boolean send(PullRequest pullRequest, ApplicationUser user, Set<UserNotification> notifications) {
        boolean hasNotifications;
        Sets.SetView commentIds;
        Object toBranchUpdates;
        Object activities;
        Set<Data> data = BatchUtils.decodeData(notifications);
        PullRequestBatchData batchData = this.dataLoader.loadData(pullRequest, data);
        Set<String> watcherUserNames = this.getWatcherUserNames(pullRequest);
        Set<PullRequestCommentActivity> rootCommentActivities = batchData.getRootCommentActivities();
        Multimap<ApplicationUser, CustomNotificationSection> customSectionsByUser = this.getCustomSections(pullRequest, user, data);
        if (watcherUserNames.contains(user.getName())) {
            activities = batchData.getActivities();
            toBranchUpdates = batchData.getToBranchUpdates();
            commentIds = batchData.getCommentIds();
        } else {
            activities = ImmutableSet.of();
            toBranchUpdates = ImmutableSet.of();
            commentIds = Sets.intersection(batchData.getMentionedCommentIds(user), batchData.getCommentIds());
        }
        Collection customSections = customSectionsByUser.get((Object)user);
        boolean bl = hasNotifications = !activities.isEmpty() || !commentIds.isEmpty() || !toBranchUpdates.isEmpty() || !customSections.isEmpty();
        if (this.isLicensedUser(user) && hasNotifications && this.hasReadPermission(user, pullRequest)) {
            Iterable allActivities = Iterables.concat((Iterable)activities, rootCommentActivities);
            PullRequestActivityRenderContext context = new PullRequestActivityRenderContext.Builder((Set<Long>)commentIds, pullRequest, ACTIONS_TO_INCLUDE_IN_PR_BATCH_EMAILS).activities(allActivities).customSections(customSections).limit(50).toBranchUpdates((Iterable<ToBranchUpdate>)toBranchUpdates).build();
            return this.sendForUser(user, context);
        }
        return true;
    }

    private boolean hasReadPermission(ApplicationUser user, PullRequest pullRequest) {
        return this.permissionService.hasRepositoryPermission(user, pullRequest.getToRef().getRepository(), Permission.REPO_READ);
    }

    private boolean isLicensedUser(ApplicationUser user) {
        return this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER);
    }

    private boolean sendForUser(ApplicationUser user, PullRequestActivityRenderContext context) {
        MutableBoolean submitted = new MutableBoolean();
        try {
            this.renderer.render(user, context).forEach(message -> {
                this.mailService.submit(message);
                submitted.setTrue();
            });
        }
        catch (MailQueueFullException e) {
            return submitted.booleanValue();
        }
        catch (MailException mailException) {
            // empty catch block
        }
        return true;
    }

    private PullRequest getPullRequest(String batchId) {
        PullRequestBatchId decodedBatchId = PullRequestBatchId.decode(batchId);
        if (decodedBatchId == null) {
            throw new IllegalStateException("Unable to decode batch ID '" + batchId + "'.");
        }
        return this.dataLoader.getPullRequest(decodedBatchId);
    }

    private Set<String> getWatcherUserNames(PullRequest pullRequest) {
        return (Set)PageUtils.toStream(pageRequest -> this.watcherService.search(new WatcherSearchRequest.Builder((Watchable)pullRequest).build(), pageRequest), (int)25).map(watcher -> watcher.getUser().getName()).collect(MoreCollectors.toImmutableSet());
    }

    private Multimap<ApplicationUser, CustomNotificationSection> getCustomSections(PullRequest pullRequest, ApplicationUser user, Set<Data> notificationData) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        this.getCustomDataByHandler(user, notificationData).forEach((rendererId, userCustomData) -> {
            CustomPullRequestNotificationRenderer renderer = this.customRendererAccessor.getRenderer((String)rendererId);
            if (renderer == null) {
                log.error("Could not find renderer with ID '{}', discarding {} custom notification(s) associated with that renderer", rendererId, (Object)userCustomData.size());
            } else {
                renderer.render(pullRequest, userCustomData.asMap()).forEach((arg_0, arg_1) -> ((ImmutableListMultimap.Builder)builder).putAll(arg_0, arg_1));
            }
        });
        return builder.build();
    }

    private Map<String, Multimap<ApplicationUser, CustomNotificationData>> getCustomDataByHandler(ApplicationUser user, Set<Data> notificationData) {
        LinkedHashMap<String, Multimap<ApplicationUser, CustomNotificationData>> rendererToCustomData = new LinkedHashMap<String, Multimap<ApplicationUser, CustomNotificationData>>();
        PullRequestBatchData.getCustomData(notificationData).forEach(customData -> rendererToCustomData.computeIfAbsent(customData.getRendererId(), rendererId -> ArrayListMultimap.create()).put((Object)user, (Object)new CustomNotificationData(customData.getData())));
        return rendererToCustomData;
    }
}

