/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.activity;

import com.atlassian.stash.internal.notification.batch.Data;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class ToBranchUpdateData
extends Data {
    private static final String USER_ID_KEY = "userId";
    private static final String TO_BRANCH_KEY = "toBranch";
    private static final String DATE_KEY = "date";
    private final int userId;
    private final String toBranch;
    private final Date date;

    public ToBranchUpdateData(int userId, String toBranch, Date date) {
        this.userId = userId;
        this.toBranch = toBranch;
        this.date = date;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getToBranch() {
        return this.toBranch;
    }

    public Date getDate() {
        return this.date;
    }

    @Override
    public String encode() throws IOException {
        ImmutableMap map = ImmutableMap.of((Object)USER_ID_KEY, (Object)this.userId, (Object)TO_BRANCH_KEY, (Object)this.toBranch, (Object)DATE_KEY, (Object)this.date.getTime());
        return DATA_MAPPER.write((Map<String, ?>)map);
    }

    @Nullable
    public static ToBranchUpdateData tryDecode(Map<String, ?> map) {
        Object userIdValue = map.get(USER_ID_KEY);
        Object toBranchValue = map.get(TO_BRANCH_KEY);
        Object dateValue = map.get(DATE_KEY);
        if (userIdValue instanceof Number && toBranchValue instanceof String && dateValue instanceof Number) {
            Number userId = (Number)userIdValue;
            Number date = (Number)dateValue;
            return new ToBranchUpdateData(userId.intValue(), (String)toBranchValue, new Date(date.longValue()));
        }
        return null;
    }
}

