/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.handlers;

import com.atlassian.bitbucket.dmz.notification.pull.PullRequestNotification;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.stash.internal.notification.handlers.AbstractNotificationHandler;
import com.atlassian.stash.internal.notification.handlers.NotificationHelper;
import com.atlassian.stash.internal.notification.handlers.WatchableMailThreadHeaderTransformer;
import com.atlassian.stash.internal.notification.pull.PullRequestNotificationUtils;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class AbstractPullRequestNotificationHandler<T extends PullRequestNotification>
extends AbstractNotificationHandler<T> {
    protected AbstractPullRequestNotificationHandler(NotificationHelper helper, String templateName) {
        super(helper, templateName);
    }

    @Override
    protected Map<String, Object> getContext(T notification) {
        Map<String, Object> context = super.getContext(notification);
        context.put("pullRequest", notification.getPullRequest());
        context.put("batchable", !this.getEnabledSendModes().contains((Object)SendMode.BATCHED));
        return context;
    }

    @Override
    protected I18nKey generateSubjectKey(PullRequestNotification notification) {
        return PullRequestNotificationUtils.createSubjectKey(notification.getPullRequest());
    }

    @Override
    protected Function<MailMessage.Builder, MailMessage.Builder> getMessageTransformer(PullRequestNotification notification) {
        return new WatchableMailThreadHeaderTransformer((Watchable)notification.getPullRequest());
    }

    @Override
    protected Set<SendMode> getEnabledSendModes() {
        return SendMode.immediateSet();
    }
}

