/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.handlers;

import com.atlassian.bitbucket.dmz.notification.pull.PullRequestFromRefRescopedNotification;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.stash.internal.notification.handlers.NotificationHelper;
import com.atlassian.stash.internal.notification.pull.handlers.AbstractPullRequestNotificationHandler;
import com.atlassian.stash.internal.notification.pull.handlers.PullRequestNotificationHelper;
import java.util.Map;

public class PullRequestFromRefRescopedNotificationHandler
extends AbstractPullRequestNotificationHandler<PullRequestFromRefRescopedNotification> {
    public static final int MAX_COMMITS_ON_RESCOPE = 5;
    private static final String TEMPLATE = "bitbucketPluginNotification.internal.feature.email.emailPullRequest.pushed";
    private final PullRequestNotificationHelper notificationHelper;

    public PullRequestFromRefRescopedNotificationHandler(NotificationHelper helper, PullRequestNotificationHelper notificationHelper) {
        super(helper, TEMPLATE);
        this.notificationHelper = notificationHelper;
    }

    @Override
    protected void renderAndDispatch(PullRequestFromRefRescopedNotification notification, Map<String, Object> context, Iterable<ApplicationUser> recipients) {
        if (PullRequestFromRefRescopedNotificationHandler.hasNewCommits(context)) {
            super.renderAndDispatch(notification, context, recipients);
        }
    }

    @Override
    protected Map<String, Object> getContext(PullRequestFromRefRescopedNotification notification) {
        Map<String, Object> context = super.getContext(notification);
        context.put("commits", this.notificationHelper.getNewCommits(notification.getPullRequest(), notification.getPreviousFromHash(), 5));
        return context;
    }

    protected static boolean hasNewCommits(Map<String, Object> context) {
        Page commits = (Page)context.get("commits");
        return commits == PullRequestNotificationHelper.THROTTLED || commits.getSize() > 0;
    }
}

