/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.handlers;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.ResourceBusyException;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestMergedNotification;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.notification.handlers.NotificationHelper;
import com.atlassian.stash.internal.notification.pull.handlers.AbstractPullRequestNotificationHandler;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestMergedNotificationHandler
extends AbstractPullRequestNotificationHandler<PullRequestMergedNotification> {
    private static final Logger log = LoggerFactory.getLogger(PullRequestMergedNotificationHandler.class);
    private static final String TEMPLATE = "bitbucketPluginNotification.internal.feature.email.emailPullRequest.merged";
    private final CommitService commitService;

    public PullRequestMergedNotificationHandler(NotificationHelper helper, CommitService commitService) {
        super(helper, TEMPLATE);
        this.commitService = commitService;
    }

    @Override
    protected Map<String, Object> getContext(PullRequestMergedNotification notification) {
        Map<String, Object> context = super.getContext(notification);
        context.put("autoMerge", notification.isAutoMerge());
        MinimalCommit commit = notification.getCommit();
        if (commit != null) {
            Repository repository = notification.getPullRequest().getToRef().getRepository();
            try {
                context.put("commit", this.commitService.getCommit(new CommitRequest.Builder(repository, commit.getId()).build()));
            }
            catch (NoSuchEntityException e) {
                String message = String.format("Merge of pull request %s in repository %s of project %s succeeded but failed to retrieve merge commit for hash %s", notification.getPullRequest(), repository.getSlug(), repository.getProject().getKey(), commit.getDisplayId());
                log.warn(message, (Throwable)e);
            }
            catch (ResourceBusyException e) {
                log.info("Couldn't retrieve the commit message for a pull request merge notification due to heavy server load.");
            }
        }
        return context;
    }
}

