/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.handlers;

import com.atlassian.bitbucket.ResourceBusyException;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;

public class PullRequestNotificationHelper {
    public static final String COMMITS_KEY = "commits";
    public static final Page<Commit> THROTTLED = PageUtils.createEmptyPage((PageRequest)PageUtils.newRequest((int)0, (int)0));
    private final CommitService commitService;
    private final EscalatedSecurityContext withRepoRead;

    public PullRequestNotificationHelper(CommitService commitService, SecurityService securityService) {
        this.commitService = commitService;
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, "PR email plugin");
    }

    public Page<Commit> getNewCommits(PullRequest pullRequest, String previousFromHash, int limit) {
        return (Page)this.withRepoRead.call(() -> {
            CommitsBetweenRequest request = new CommitsBetweenRequest.Builder(pullRequest).exclude(previousFromHash, new String[0]).build();
            return this.fetchCommits(request, limit);
        });
    }

    public Page<Commit> getCommits(PullRequest pullRequest, int limit) {
        return (Page)this.withRepoRead.call(() -> this.fetchCommits(new CommitsBetweenRequest.Builder(pullRequest).build(), limit));
    }

    private Page<Commit> fetchCommits(CommitsBetweenRequest request, int limit) {
        try {
            return this.commitService.getCommitsBetween(request, PageUtils.newRequest((int)0, (int)limit));
        }
        catch (ResourceBusyException e) {
            return THROTTLED;
        }
    }
}

