/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.handlers;

import com.atlassian.bitbucket.dmz.notification.Notification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestOpenedNotification;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.notification.handlers.NotificationHelper;
import com.atlassian.stash.internal.notification.mention.MentionHelper;
import com.atlassian.stash.internal.notification.pull.handlers.AbstractPullRequestNotificationHandler;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Set;
import java.util.stream.Collectors;

public class PullRequestOpenedNotificationHandler
extends AbstractPullRequestNotificationHandler<PullRequestOpenedNotification> {
    private static final String TEMPLATE = "bitbucketPluginNotification.internal.feature.email.emailPullRequest.mentionDescription";
    private final MentionHelper mentionHelper;

    public PullRequestOpenedNotificationHandler(NotificationHelper helper, MentionHelper mentionHelper) {
        super(helper, TEMPLATE);
        this.mentionHelper = mentionHelper;
    }

    @Override
    public void handle(@Nonnull PullRequestOpenedNotification notification, @Nonnull Iterable<ApplicationUser> recipients) {
        PullRequest pullRequest = notification.getPullRequest();
        Sets.SetView mentionedUsers = Sets.difference(this.mentionHelper.findUsers((Notification)notification, pullRequest.getDescription()), pullRequest.getReviewers().stream().map(PullRequestParticipant::getUser).collect(Collectors.toSet()));
        super.handle(notification, (Iterable<ApplicationUser>)mentionedUsers);
    }

    @Override
    protected Set<SendMode> getEnabledSendModes() {
        return SendMode.batchedAndImmediateSet();
    }
}

