/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.handlers;

import com.atlassian.bitbucket.dmz.notification.Notification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestUpdatedNotification;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.notification.handlers.NotificationHelper;
import com.atlassian.stash.internal.notification.mention.MentionHelper;
import com.atlassian.stash.internal.notification.pull.handlers.AbstractPullRequestNotificationHandler;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import jakarta.annotation.Nonnull;
import java.util.Set;

public class PullRequestUpdatedNotificationHandler
extends AbstractPullRequestNotificationHandler<PullRequestUpdatedNotification> {
    private static final String TEMPLATE = "bitbucketPluginNotification.internal.feature.email.emailPullRequest.mentionDescription";
    private final MentionHelper mentionHelper;

    public PullRequestUpdatedNotificationHandler(NotificationHelper helper, MentionHelper mentionHelper) {
        super(helper, TEMPLATE);
        this.mentionHelper = mentionHelper;
    }

    @Override
    public void handle(@Nonnull PullRequestUpdatedNotification notification, @Nonnull Iterable<ApplicationUser> recipients) {
        super.handle(notification, (Iterable<ApplicationUser>)this.mentionHelper.findUsers((Notification)notification, this.getMentionedUsers(notification)));
    }

    private Set<String> getMentionedUsers(PullRequestUpdatedNotification notification) {
        return this.mentionHelper.getMentionedUsersDifference(notification.getPreviousDescription(), notification.getPullRequest().getDescription());
    }

    @Override
    protected Set<SendMode> getEnabledSendModes() {
        return SendMode.batchedAndImmediateSet();
    }
}

