/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository;

import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.watcher.WatchRequest;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsSearchRequest;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsService;
import com.atlassian.stash.internal.notification.repository.dao.MinimalRepositoryNotificationSettings;
import com.atlassian.stash.internal.notification.repository.dao.RepositoryNotificationSettingsDao;
import com.atlassian.stash.internal.notification.repository.dao.RepositoryNotificationSettingsSearchCriteria;
import com.atlassian.stash.internal.notification.repository.event.RepositoryNotificationSettingsUpdatedEvent;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.atlassian.stash.internal.notification.repository.model.SimpleRepositoryNotificationSettings;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRepositoryNotificationSettingsService
implements RepositoryNotificationSettingsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultRepositoryNotificationSettingsService.class);
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final RepositoryService repositoryService;
    private final RepositoryNotificationSettingsDao settingsDao;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;
    private final WatcherService watcherService;

    public DefaultRepositoryNotificationSettingsService(EventPublisher eventPublisher, ExecutorService executorService, PermissionService permissionService, PermissionValidationService permissionValidationService, RepositoryService repositoryService, RepositoryNotificationSettingsDao settingsDao, TransactionTemplate transactionTemplate, UserService userService, WatcherService watcherService) {
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.repositoryService = repositoryService;
        this.settingsDao = settingsDao;
        this.transactionTemplate = transactionTemplate;
        this.userService = userService;
        this.watcherService = watcherService;
    }

    @Override
    @Nonnull
    public Set<PushNotificationScope> filterScopesByRepository(@Nonnull Repository repository, @Nonnull Set<PushNotificationScope> scopes) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(scopes, "scopes");
        return (Set)this.transactionTemplate.execute(() -> this.settingsDao.filterScopesByRepositoryId(repository.getId(), scopes));
    }

    @Override
    @Nonnull
    public Optional<RepositoryNotificationSettings> getByRepositoryAndUser(@Nonnull Repository repository, @Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(repository, "repository");
        this.permissionValidationService.validateForUser(user, Permission.USER_ADMIN);
        return ((Optional)this.transactionTemplate.execute(() -> {
            int repositoryId = repository.getId();
            return this.settingsDao.getByRepositoryAndUser(repositoryId, user.getId());
        })).map(settings -> this.toSimpleNotificationSettings((MinimalRepositoryNotificationSettings)settings, repository, user));
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.executorService.execute(() -> this.transactionTemplate.execute(() -> {
            this.settingsDao.deleteByRepository(event.getRepository().getId());
            return null;
        }));
    }

    @EventListener
    public void onUserCleanup(UserCleanupEvent event) {
        this.executorService.execute(() -> this.transactionTemplate.execute(() -> {
            this.settingsDao.deleteByUser(event.getDeletedUser().getId());
            return null;
        }));
    }

    @Override
    @Nonnull
    public Page<RepositoryNotificationSettings> search(@Nonnull RepositoryNotificationSettingsSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        Optional<Repository> repository = request.getRepository();
        Optional<ApplicationUser> user = request.getUser();
        repository.ifPresent(r -> this.permissionValidationService.validateForRepository(r, Permission.REPO_READ));
        user.ifPresent(u -> this.permissionValidationService.validateForUser(u, Permission.USER_ADMIN));
        IndexingPredicate indexingPredicate = new IndexingPredicate(repository.orElse(null), user.orElse(null));
        return (Page)this.transactionTemplate.execute(() -> {
            RepositoryNotificationSettingsSearchCriteria criteria = new RepositoryNotificationSettingsSearchCriteria.Builder(request).build();
            Page settingsPage = PageUtils.filterPages(filtered -> this.settingsDao.search(criteria, filtered), (Predicate)indexingPredicate, (PageRequest)pageRequest);
            HashMap defaultBranchCache = new HashMap();
            indexingPredicate.getRepositoryIds().forEach(id -> defaultBranchCache.put(id, this.getDefaultBranch(indexingPredicate.getRepository((int)id))));
            return settingsPage.transform(settings -> this.toSimpleNotificationSettings((MinimalRepositoryNotificationSettings)settings, indexingPredicate.getRepository(settings.getRepositoryId()), indexingPredicate.getUser(settings.getUserId()), (MinimalRef)defaultBranchCache.get(settings.getRepositoryId())));
        });
    }

    @Override
    @Nonnull
    public RepositoryNotificationSettings set(@Nonnull ApplicationUser user, @Nonnull Repository repository, @Nonnull PullRequestNotificationScope pullRequestScope, @Nonnull PushNotificationScope pushScope) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(pullRequestScope, "pullRequestNotificationScope");
        Objects.requireNonNull(pushScope, "pushNotificationScope");
        this.permissionValidationService.validateForUser(user, Permission.USER_ADMIN);
        return (RepositoryNotificationSettings)this.transactionTemplate.execute(() -> {
            this.updateWatcher(repository, pullRequestScope, pushScope);
            RepositoryNotificationSettings previousSettings = this.settingsDao.getByRepositoryAndUser(repository.getId(), user.getId()).map(settings -> this.toSimpleNotificationSettings((MinimalRepositoryNotificationSettings)settings, repository, user)).orElse(null);
            MinimalRepositoryNotificationSettings newSettings = this.settingsDao.saveOrUpdate(repository.getId(), user.getId(), pullRequestScope, pushScope);
            RepositoryNotificationSettings enrichedSettings = this.toSimpleNotificationSettings(newSettings, repository, user);
            this.eventPublisher.publish((Object)new RepositoryNotificationSettingsUpdatedEvent(this, enrichedSettings, previousSettings));
            return enrichedSettings;
        });
    }

    private MinimalRef getDefaultBranch(Repository repository) {
        return this.repositoryService.getDefaultBranch(repository);
    }

    private RepositoryNotificationSettings toSimpleNotificationSettings(MinimalRepositoryNotificationSettings settings, Repository repository, ApplicationUser user) {
        return this.toSimpleNotificationSettings(settings, repository, user, this.getDefaultBranch(repository));
    }

    private RepositoryNotificationSettings toSimpleNotificationSettings(MinimalRepositoryNotificationSettings settings, Repository repository, ApplicationUser user, MinimalRef defaultBranch) {
        return new SimpleRepositoryNotificationSettings.Builder(repository, user).pullRequestNotificationScope(settings.getPullRequestNotificationScope()).pushNotificationScope(settings.getPushNotificationScope()).defaultBranch(defaultBranch).build();
    }

    private void updateWatcher(Repository repository, PullRequestNotificationScope pullRequestScope, PushNotificationScope pushScope) {
        if (pullRequestScope != PullRequestNotificationScope.NONE || pushScope != PushNotificationScope.NONE) {
            this.watcherService.watch(new WatchRequest.Builder((Watchable)repository).build());
        }
    }

    private class IndexingPredicate
    implements Predicate<MinimalRepositoryNotificationSettings> {
        private final Map<Integer, Repository> repositoriesById;
        private final Repository repository;
        private final ApplicationUser user;
        private final Map<Integer, ApplicationUser> usersById;

        private IndexingPredicate(Repository repository, ApplicationUser user) {
            this.repository = repository;
            this.user = user;
            this.repositoriesById = new HashMap<Integer, Repository>();
            this.usersById = new HashMap<Integer, ApplicationUser>();
        }

        @Override
        public boolean test(MinimalRepositoryNotificationSettings settings) {
            if (this.user == null) {
                ApplicationUser searchUser = DefaultRepositoryNotificationSettingsService.this.userService.getUserById(settings.getUserId());
                if (searchUser == null) {
                    return false;
                }
                this.usersById.put(searchUser.getId(), searchUser);
            }
            if (this.repository == null) {
                int repositoryId = settings.getRepositoryId();
                if (!DefaultRepositoryNotificationSettingsService.this.permissionService.hasRepositoryPermission(repositoryId, Permission.REPO_READ)) {
                    return false;
                }
                Repository searchRepository = DefaultRepositoryNotificationSettingsService.this.repositoryService.getById(repositoryId);
                if (searchRepository == null) {
                    log.warn("Found notification settings for user {} and missing repository {}. Removing orphan settings", (Object)settings.getUserId(), (Object)repositoryId);
                    DefaultRepositoryNotificationSettingsService.this.executorService.execute(new RepositorySettingsCleanupTask(repositoryId));
                    return false;
                }
                this.repositoriesById.put(repositoryId, searchRepository);
            }
            return true;
        }

        private Repository getRepository(int repositoryId) {
            return this.repository == null ? this.repositoriesById.get(repositoryId) : this.repository;
        }

        private Set<Integer> getRepositoryIds() {
            return this.repository == null ? this.repositoriesById.keySet() : Collections.singleton(this.repository.getId());
        }

        private ApplicationUser getUser(int userId) {
            return this.user == null ? this.usersById.get(userId) : this.user;
        }
    }

    private class RepositorySettingsCleanupTask
    implements Runnable {
        private final int repositoryId;

        private RepositorySettingsCleanupTask(int repositoryId) {
            this.repositoryId = repositoryId;
        }

        @Override
        public void run() {
            DefaultRepositoryNotificationSettingsService.this.transactionTemplate.execute(() -> {
                try {
                    DefaultRepositoryNotificationSettingsService.this.settingsDao.deleteByRepository(this.repositoryId);
                }
                catch (Exception e) {
                    log.warn("Failed to delete settings for unknown repository ID {}", (Object)this.repositoryId, (Object)e);
                }
                log.debug("Cleaned up settings for repository {}", (Object)this.repositoryId);
                return null;
            });
        }
    }
}

