/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class RepositoryNotificationSettingsSearchRequest {
    private final Set<PullRequestNotificationScope> pullRequestNotificationScopes;
    private final Set<PushNotificationScope> pushNotificationScopes;
    private final Repository repository;
    private final ApplicationUser user;

    private RepositoryNotificationSettingsSearchRequest(Builder builder) {
        this.pullRequestNotificationScopes = builder.pullRequestNotificationScopes.build();
        this.pushNotificationScopes = builder.pushNotificationScopes.build();
        this.repository = builder.repository;
        this.user = builder.user;
    }

    @Nonnull
    public Set<PullRequestNotificationScope> getPullRequestNotificationScopes() {
        return this.pullRequestNotificationScopes;
    }

    @Nonnull
    public Set<PushNotificationScope> getPushNotificationScopes() {
        return this.pushNotificationScopes;
    }

    @Nonnull
    public Optional<Repository> getRepository() {
        return Optional.ofNullable(this.repository);
    }

    @Nonnull
    public Optional<ApplicationUser> getUser() {
        return Optional.ofNullable(this.user);
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<PullRequestNotificationScope> pullRequestNotificationScopes = ImmutableSet.builder();
        private final ImmutableSet.Builder<PushNotificationScope> pushNotificationScopes = ImmutableSet.builder();
        private Repository repository;
        private ApplicationUser user;

        @Nonnull
        public RepositoryNotificationSettingsSearchRequest build() {
            return new RepositoryNotificationSettingsSearchRequest(this);
        }

        @Nonnull
        public Builder pullRequestNotificationScopes(@Nonnull Iterable<PullRequestNotificationScope> values) {
            Builder.addIf(Objects::nonNull, this.pullRequestNotificationScopes, values);
            return this;
        }

        @Nonnull
        public Builder pushNotificationScopes(@Nonnull Iterable<PushNotificationScope> values) {
            Builder.addIf(Objects::nonNull, this.pushNotificationScopes, values);
            return this;
        }

        @Nonnull
        public Builder repository(@Nullable Repository value) {
            this.repository = value;
            return this;
        }

        @Nonnull
        public Builder user(@Nullable ApplicationUser value) {
            this.user = value;
            return this;
        }
    }
}

