/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.batch;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestActivityRenderContext;
import com.atlassian.stash.internal.notification.repository.batch.PullRequestStateChangeContext;
import com.atlassian.stash.internal.notification.repository.batch.PushContext;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BatchRepositoryNotificationContext {
    private final MinimalRef defaultBranch;
    private final boolean hasMorePullRequests;
    private final boolean hasMorePullRequestStateChanges;
    private final boolean hasMorePushActivity;
    private final int numberOfPullRequestsUpdated;
    private final int numberOfPushes;
    private final List<PullRequestActivityRenderContext> pullRequestActivityItems;
    private final List<PullRequestStateChangeContext> pullRequestStateChanges;
    private final List<PushContext> pushActivityChanges;
    private final Repository repository;
    private final ApplicationUser user;

    private BatchRepositoryNotificationContext(Builder builder) {
        this.defaultBranch = builder.defaultBranch;
        this.hasMorePullRequests = builder.hasMorePullRequests;
        this.hasMorePullRequestStateChanges = builder.hasMorePullRequestStateChanges;
        this.hasMorePushActivity = builder.hasMorePushActivity;
        this.numberOfPullRequestsUpdated = builder.numberOfPullRequestsUpdated;
        this.numberOfPushes = builder.numberOfPushes;
        this.pullRequestActivityItems = builder.pullRequestActivityItems.build();
        this.pullRequestStateChanges = builder.pullRequestStateChanges.build();
        this.pushActivityChanges = builder.pushActivityChanges.build();
        this.repository = builder.repository;
        this.user = builder.user;
    }

    @Nonnull
    public Optional<MinimalRef> getDefaultBranch() {
        return Optional.ofNullable(this.defaultBranch);
    }

    public int getNumberOfPushes() {
        return this.numberOfPushes;
    }

    public int getNumberOfPullRequestsUpdated() {
        return this.numberOfPullRequestsUpdated;
    }

    @Nonnull
    public List<PullRequestActivityRenderContext> getPullRequestActivityItems() {
        return this.pullRequestActivityItems;
    }

    @Nonnull
    public List<PullRequestStateChangeContext> getPullRequestStateChanges() {
        return this.pullRequestStateChanges;
    }

    @Nonnull
    public List<PushContext> getPushActivityChanges() {
        return this.pushActivityChanges;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    public boolean hasMorePullRequests() {
        return this.hasMorePullRequests;
    }

    public boolean hasMorePullRequestStateChanges() {
        return this.hasMorePullRequestStateChanges;
    }

    public boolean hasMorePushActivity() {
        return this.hasMorePushActivity;
    }

    public static class Builder
    extends BuilderSupport {
        private MinimalRef defaultBranch;
        private boolean hasMorePullRequests;
        private boolean hasMorePullRequestStateChanges;
        private boolean hasMorePushActivity;
        private int numberOfPushes;
        private int numberOfPullRequestsUpdated;
        private final ImmutableList.Builder<PullRequestActivityRenderContext> pullRequestActivityItems;
        private final ImmutableList.Builder<PullRequestStateChangeContext> pullRequestStateChanges;
        private final ImmutableList.Builder<PushContext> pushActivityChanges;
        private Repository repository;
        private ApplicationUser user;

        @Nonnull
        public Builder(@Nonnull ApplicationUser user, @Nonnull Repository repository) {
            this.user = Objects.requireNonNull(user, "user");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.pullRequestActivityItems = ImmutableList.builder();
            this.pullRequestStateChanges = ImmutableList.builder();
            this.pushActivityChanges = ImmutableList.builder();
        }

        @Nonnull
        public BatchRepositoryNotificationContext build() {
            return new BatchRepositoryNotificationContext(this);
        }

        @Nonnull
        public Builder defaultBranch(@Nullable MinimalRef value) {
            this.defaultBranch = value;
            return this;
        }

        @Nonnull
        public Builder hasMorePullRequests(boolean value) {
            this.hasMorePullRequests = value;
            return this;
        }

        @Nonnull
        public Builder hasMorePullRequestStateChanges(boolean value) {
            this.hasMorePullRequestStateChanges = value;
            return this;
        }

        @Nonnull
        public Builder hasMorePushActivity(boolean value) {
            this.hasMorePushActivity = value;
            return this;
        }

        public Builder numberOfPullRequestsUpdated(@Nonnull Integer value) {
            this.numberOfPullRequestsUpdated = Objects.requireNonNull(value, "numberOfPullRequestsUpdated");
            return this;
        }

        @Nonnull
        public Builder numberOfPushes(@Nonnull Integer value) {
            this.numberOfPushes = Objects.requireNonNull(value, "numberOfPushes");
            return this;
        }

        @Nonnull
        public Builder pullRequestActivityItems(@Nonnull Iterable<PullRequestActivityRenderContext> values) {
            Builder.addIf(Objects::nonNull, this.pullRequestActivityItems, values);
            return this;
        }

        @Nonnull
        public Builder pullRequestStateChanges(@Nonnull Iterable<PullRequestStateChangeContext> values) {
            Builder.addIf(Objects::nonNull, this.pullRequestStateChanges, values);
            return this;
        }

        @Nonnull
        public Builder pushActivityChanges(@Nonnull Iterable<PushContext> values) {
            Builder.addIf(Objects::nonNull, this.pushActivityChanges, values);
            return this;
        }
    }
}

