/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.batch;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.repository.DetailedRefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.notification.batch.BatchUtils;
import com.atlassian.stash.internal.notification.batch.dao.UserNotification;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestActivityRenderContext;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestBatchData;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestBatchDataLoader;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestBatchId;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsService;
import com.atlassian.stash.internal.notification.repository.batch.BatchRepositoryNotificationContext;
import com.atlassian.stash.internal.notification.repository.batch.DetailedRefChangeCache;
import com.atlassian.stash.internal.notification.repository.batch.DetailedRefChangeCacheFactory;
import com.atlassian.stash.internal.notification.repository.batch.PullRequestStateChangeContext;
import com.atlassian.stash.internal.notification.repository.batch.PushContext;
import com.atlassian.stash.internal.notification.repository.batch.RepositoryBatchId;
import com.atlassian.stash.internal.notification.repository.batch.RepositoryUpdateData;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BatchRepositoryNotificationContextFactory {
    private static final Set<PullRequestAction> STATE_CHANGE_ACTIONS = ImmutableSet.of((Object)PullRequestAction.OPENED, (Object)PullRequestAction.DECLINED, (Object)PullRequestAction.MERGED, (Object)PullRequestAction.REOPENED, (Object)PullRequestAction.DELETED);
    private static final Set<PullRequestAction> DEFAULT_WORKFLOW_ACTIONS = ImmutableSet.builder().addAll(STATE_CHANGE_ACTIONS).add((Object)PullRequestAction.APPROVED).add((Object)PullRequestAction.UNAPPROVED).add((Object)PullRequestAction.REVIEWED).add((Object)PullRequestAction.AUTO_MERGE_CANCELLED).add((Object)PullRequestAction.AUTO_MERGE_REQUESTED).build();
    private final DetailedRefChangeCacheFactory detailedRefChangeCacheFactory;
    private final PullRequestBatchDataLoader pullRequestBatchDataLoader;
    private final RepositoryNotificationSettingsService repositoryNotificationSettingsService;
    private final UserService userService;

    public BatchRepositoryNotificationContextFactory(DetailedRefChangeCacheFactory detailedRefChangeCacheFactory, PullRequestBatchDataLoader pullRequestBatchDataLoader, RepositoryNotificationSettingsService repositoryNotificationSettingsService, UserService userService) {
        this.detailedRefChangeCacheFactory = detailedRefChangeCacheFactory;
        this.pullRequestBatchDataLoader = pullRequestBatchDataLoader;
        this.repositoryNotificationSettingsService = repositoryNotificationSettingsService;
        this.userService = userService;
    }

    @Nonnull
    public BatchRepositoryNotificationContext createContext(@Nonnull Repository repository, @Nonnull ApplicationUser user, @Nonnull Set<UserNotification> notifications) {
        RepositoryNotificationSettings settings = this.getNotificationSettings(user, repository);
        BatchRepositoryNotificationContext.Builder builder = new BatchRepositoryNotificationContext.Builder(user, repository);
        notifications.stream().collect(Collectors.groupingBy(DataType::from, MoreCollectors.toImmutableSet())).forEach((type, userNotifications) -> {
            if (type == DataType.REPOSITORY && settings.getPushNotificationScope() != PushNotificationScope.NONE) {
                this.addPushNotificationData(builder, (Set<UserNotification>)userNotifications, settings, repository);
            } else if (type == DataType.PULL_REQUEST && settings.getPullRequestNotificationScope() != PullRequestNotificationScope.NONE) {
                this.addPullRequestData(builder, (Set<UserNotification>)userNotifications, settings, user);
            }
        });
        return builder.build();
    }

    private static boolean filterRef(RepositoryNotificationSettings settings, DetailedRefChange refChange) {
        return PushNotificationScope.DEFAULT_BRANCH.equals((Object)settings.getPushNotificationScope()) && refChange.getRef().getId().equals(settings.getDefaultBranch().getId()) || PushNotificationScope.ALL.equals((Object)settings.getPushNotificationScope());
    }

    private static List<PullRequestActivity> toListOfStateChangeActivities(PullRequestBatchData data) {
        return (List)data.getActivities().stream().filter(pullRequestActivity -> STATE_CHANGE_ACTIONS.contains(pullRequestActivity.getAction())).collect(MoreCollectors.toImmutableList());
    }

    private static PullRequestActivityRenderContext toPullRequestActivityRenderContext(PullRequestBatchData data) {
        return new PullRequestActivityRenderContext.Builder(data.getCommentIds(), data.getPullRequest(), DEFAULT_WORKFLOW_ACTIONS).activities(Iterables.concat(data.getActivities(), data.getRootCommentActivities())).toBranchUpdates(data.getToBranchUpdates()).limit(5).build();
    }

    private void addPullRequestData(BatchRepositoryNotificationContext.Builder builder, Set<UserNotification> notifications, RepositoryNotificationSettings settings, ApplicationUser user) {
        List<PullRequestBatchData> pullRequestData = this.getPullRequestBatchData(user, notifications);
        builder.numberOfPullRequestsUpdated(pullRequestData.size());
        if (PullRequestNotificationScope.ALL.equals((Object)settings.getPullRequestNotificationScope())) {
            List pullRequestActivityRenderContexts = (List)pullRequestData.stream().map(BatchRepositoryNotificationContextFactory::toPullRequestActivityRenderContext).filter(context -> !context.getSortedItems().isEmpty()).sorted(new PullRequestActivityRenderContextComparator()).collect(MoreCollectors.toImmutableList());
            if (pullRequestActivityRenderContexts.size() > 50) {
                builder.hasMorePullRequests(true);
            }
            builder.pullRequestActivityItems((Iterable)pullRequestActivityRenderContexts.stream().limit(50L).collect(MoreCollectors.toImmutableList()));
        } else if (PullRequestNotificationScope.STATE_CHANGES.equals((Object)settings.getPullRequestNotificationScope())) {
            List stateChanges = (List)pullRequestData.stream().map(BatchRepositoryNotificationContextFactory::toListOfStateChangeActivities).flatMap(Collection::stream).sorted(new ActivityDateComparator()).map(PullRequestStateChangeContext::new).collect(MoreCollectors.toImmutableList());
            if (stateChanges.size() > 50) {
                builder.hasMorePullRequestStateChanges(true);
            }
            builder.pullRequestStateChanges((Iterable)stateChanges.stream().limit(50L).collect(MoreCollectors.toImmutableList()));
        }
    }

    private void addPushNotificationData(BatchRepositoryNotificationContext.Builder builder, Set<UserNotification> notifications, RepositoryNotificationSettings settings, Repository repository) {
        List orderedNotifications = (List)notifications.stream().sorted(new UserNotificationDateComparator()).collect(MoreCollectors.toImmutableList());
        List repositoryUpdateData = (List)BatchUtils.decodeData(orderedNotifications).stream().filter(RepositoryUpdateData.class::isInstance).map(RepositoryUpdateData.class::cast).collect(MoreCollectors.toImmutableList());
        DetailedRefChangeCache cache = this.detailedRefChangeCacheFactory.create(repository, repositoryUpdateData);
        List pushes = (List)repositoryUpdateData.stream().map(data -> this.toPushContext(cache, settings, (RepositoryUpdateData)data)).filter(Objects::nonNull).collect(MoreCollectors.toImmutableList());
        builder.numberOfPushes(pushes.size());
        ImmutableList.Builder truncatedPushes = ImmutableList.builder();
        int amountOfRefs = 0;
        boolean hasMorePushActivity = false;
        for (PushContext push : pushes) {
            if (amountOfRefs < 50) {
                truncatedPushes.add((Object)push);
                amountOfRefs += push.getChanges().size();
                if (!push.hasExtraRefChanges()) continue;
                hasMorePushActivity = true;
                continue;
            }
            hasMorePushActivity = true;
            break;
        }
        builder.hasMorePushActivity(hasMorePushActivity);
        builder.pushActivityChanges((Iterable<PushContext>)truncatedPushes.build());
        if (PushNotificationScope.DEFAULT_BRANCH.equals((Object)settings.getPushNotificationScope())) {
            builder.defaultBranch(settings.getDefaultBranch());
        }
    }

    private List<DetailedRefChange> getDetailedRefChanges(DetailedRefChangeCache cache, RepositoryUpdateData repositoryUpdateData) {
        return (List)repositoryUpdateData.getDetailedRefChanges().stream().map(cache::toDetailedRefChange).filter(Objects::nonNull).collect(MoreCollectors.toImmutableList());
    }

    private RepositoryNotificationSettings getNotificationSettings(ApplicationUser user, Repository repository) {
        RepositoryNotificationSettings settings = this.repositoryNotificationSettingsService.getByRepositoryAndUser(repository, user).orElse(null);
        if (settings == null) {
            throw new IllegalStateException("User needs to have repository notification settings.");
        }
        return settings;
    }

    private PullRequest getPullRequest(UserNotification notification) {
        return this.pullRequestBatchDataLoader.getPullRequest(PullRequestBatchId.decode(notification.getBatchId()));
    }

    private List<PullRequestBatchData> getPullRequestBatchData(ApplicationUser user, Set<UserNotification> notifications) {
        return (List)notifications.stream().filter(notification -> this.getPullRequest((UserNotification)notification) != null).collect(Collectors.groupingBy(this::getPullRequest, MoreCollectors.toImmutableSet())).entrySet().stream().map(entry -> this.pullRequestBatchDataLoader.loadData((PullRequest)entry.getKey(), BatchUtils.decodeData((Set)entry.getValue()))).collect(MoreCollectors.toImmutableList());
    }

    private PushContext toPushContext(DetailedRefChangeCache cache, RepositoryNotificationSettings settings, RepositoryUpdateData repositoryUpdateData) {
        List refChanges = (List)this.getDetailedRefChanges(cache, repositoryUpdateData).stream().filter(refChange -> BatchRepositoryNotificationContextFactory.filterRef(settings, refChange)).collect(MoreCollectors.toImmutableList());
        if (refChanges.size() == 0) {
            return null;
        }
        ApplicationUser pusher = Optional.ofNullable(this.userService.getUserById(repositoryUpdateData.getPushingUserId())).orElseThrow(() -> new IllegalStateException("Cannot find user with id: " + repositoryUpdateData.getPushingUserId()));
        return new PushContext.Builder(pusher).detailedRefChanges(refChanges).hasExtraRefChanges(repositoryUpdateData.hasExtraRefChanges()).build();
    }

    private static class PullRequestActivityRenderContextComparator
    implements Comparator<PullRequestActivityRenderContext> {
        private PullRequestActivityRenderContextComparator() {
        }

        @Override
        public int compare(PullRequestActivityRenderContext context, PullRequestActivityRenderContext other) {
            return this.getDate(context).compareTo(this.getDate(other));
        }

        private Date getDate(PullRequestActivityRenderContext context) {
            return context.getSortedItems().stream().map(item -> (Date)item.get("date")).findFirst().orElseThrow(() -> new IllegalStateException("Every context should have a first activity date"));
        }
    }

    private static class ActivityDateComparator
    implements Comparator<PullRequestActivity> {
        private ActivityDateComparator() {
        }

        @Override
        public int compare(PullRequestActivity activity, PullRequestActivity other) {
            return activity.getCreatedDate().compareTo(other.getCreatedDate());
        }
    }

    private static class UserNotificationDateComparator
    implements Comparator<UserNotification> {
        private UserNotificationDateComparator() {
        }

        @Override
        public int compare(UserNotification notification, UserNotification other) {
            return notification.getTimestamp().compareTo(other.getTimestamp());
        }
    }

    private static enum DataType {
        PULL_REQUEST,
        REPOSITORY;


        private static DataType from(UserNotification value) {
            if (value.getBatchId() == null) {
                return null;
            }
            if (PullRequestBatchId.decode(value.getBatchId()) != null) {
                return PULL_REQUEST;
            }
            if (RepositoryBatchId.decode(value.getBatchId()) != null) {
                return REPOSITORY;
            }
            throw new IllegalStateException("BatchId needs to be for a Pull request or a repository");
        }
    }
}

