/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.batch;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.repository.DetailedRefChange;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.SimpleDetailedRefChange;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.repository.SimpleRefChangeDetails;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.notification.repository.batch.DetailedRefChangeData;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DetailedRefChangeCache {
    private final Map<String, Commit> commitCache;
    private final Map<String, Ref> refCache;

    public DetailedRefChangeCache(Map<String, Commit> commitCache, Map<String, Ref> refCache) {
        this.commitCache = commitCache;
        this.refCache = refCache;
    }

    @Nullable
    public DetailedRefChange toDetailedRefChange(@Nonnull DetailedRefChangeData data) {
        Objects.requireNonNull(data, "detailedRefChangeData");
        Ref ref = this.refCache.get(data.getRefId());
        if (ref == null) {
            return null;
        }
        SimpleRefChange.Builder refChangeBuilder = new SimpleRefChange.Builder();
        SimpleRefChange refChange = ((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)refChangeBuilder.fromHash(data.getFromHash())).ref((MinimalRef)ref)).toHash(data.getToHash())).type(RefChangeType.fromId((int)data.getRefChangeTypeId()))).build();
        SimpleDetailedRefChange.Builder builder = new SimpleDetailedRefChange.Builder((RefChange)refChange);
        return builder.added(new SimpleRefChangeDetails.Builder().commits(this.getCommitsFromCache(data.getAddedCommitIds())).totalCommits(data.getTotalAddedCommits()).build()).removed(new SimpleRefChangeDetails.Builder().commits(this.getCommitsFromCache(data.getRemovedCommitIds())).totalCommits(data.getTotalRemovedCommits()).build()).build();
    }

    private List<Commit> getCommitsFromCache(List<String> commitIds) {
        return (List)commitIds.stream().map(this.commitCache::get).collect(MoreCollectors.toImmutableList());
    }
}

