/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.batch;

import com.atlassian.bitbucket.commit.BulkCommitsRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ResolveRefsRequest;
import com.atlassian.stash.internal.notification.repository.batch.DetailedRefChangeCache;
import com.atlassian.stash.internal.notification.repository.batch.RepositoryUpdateData;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class DetailedRefChangeCacheFactory {
    private final CommitService commitService;
    private final RefService refService;

    public DetailedRefChangeCacheFactory(CommitService commitService, RefService refService) {
        this.commitService = commitService;
        this.refService = refService;
    }

    @Nonnull
    public DetailedRefChangeCache create(@Nonnull Repository repository, @Nonnull Collection<RepositoryUpdateData> updateData) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(updateData, "updateData");
        ImmutableSet.Builder refListBuilder = ImmutableSet.builder();
        ImmutableSet.Builder commitListBuilder = ImmutableSet.builder();
        updateData.stream().map(RepositoryUpdateData::getDetailedRefChanges).flatMap(Collection::stream).forEach(detailedRefChangeData -> {
            refListBuilder.add((Object)detailedRefChangeData.getRefId());
            commitListBuilder.addAll(detailedRefChangeData.getAddedCommitIds()).addAll(detailedRefChangeData.getRemovedCommitIds());
        });
        ImmutableMap.Builder commitCacheBuilder = ImmutableMap.builder();
        BulkCommitsRequest bulkCommitsRequest = new BulkCommitsRequest.Builder().commits(repository, (Iterable)commitListBuilder.build()).build();
        this.commitService.streamCommits(bulkCommitsRequest, (commit, repositories) -> {
            commitCacheBuilder.put((Object)commit.getId(), (Object)commit);
            return true;
        });
        ResolveRefsRequest request = new ResolveRefsRequest.Builder(repository).refIds((Iterable)refListBuilder.build()).build();
        return new DetailedRefChangeCache((Map<String, Commit>)commitCacheBuilder.build(), this.refService.resolveRefs(request));
    }
}

