/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.batch;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DetailedRefChangeData {
    private static final String ADDED_COMMIT_IDS = "addedCommitIds";
    private static final String FROM_HASH = "fromHash";
    private static final String REF_ID = "refId";
    private static final String REMOVED_COMMIT_IDS = "removedCommitIds";
    private static final String TO_HASH = "toHash";
    private static final String TOTAL_ADDED_COMMITS = "totalAddedCommits";
    private static final String TOTAL_REMOVED_COMMITS = "totalRemovedCommits";
    private static final String REF_CHANGE_TYPE_ID = "refChangeTypeId";
    private final List<String> addedCommitIds;
    private final String fromHash;
    private final String refId;
    private final List<String> removedCommitIds;
    private final String toHash;
    private final int totalAddedCommits;
    private final int totalRemovedCommits;
    private final int refChangeTypeId;

    private DetailedRefChangeData(@Nonnull Builder builder) {
        this.addedCommitIds = builder.addedCommitIds.build();
        this.fromHash = Objects.requireNonNull(builder.fromHash, FROM_HASH);
        this.refId = Objects.requireNonNull(builder.refId, REF_ID);
        this.removedCommitIds = builder.removedCommitIds.build();
        this.refChangeTypeId = Objects.requireNonNull(builder.refChangeTypeId, REF_CHANGE_TYPE_ID);
        this.toHash = Objects.requireNonNull(builder.toHash, TO_HASH);
        this.totalAddedCommits = builder.totalAddedCommits;
        this.totalRemovedCommits = builder.totalRemovedCommits;
    }

    public static DetailedRefChangeData decode(Map<String, ?> map) {
        return new Builder().addedCommitIds((Iterable)map.get(ADDED_COMMIT_IDS)).fromHash((String)map.get(FROM_HASH)).refId((String)map.get(REF_ID)).removedCommitIds((Iterable)map.get(REMOVED_COMMIT_IDS)).toHash((String)map.get(TO_HASH)).totalAddedCommits(((Number)map.get(TOTAL_ADDED_COMMITS)).intValue()).totalRemovedCommits(((Number)map.get(TOTAL_REMOVED_COMMITS)).intValue()).refChangeTypeId(((Number)map.get(REF_CHANGE_TYPE_ID)).intValue()).build();
    }

    public Map<String, Object> encode() {
        return ImmutableMap.builder().put((Object)ADDED_COMMIT_IDS, this.addedCommitIds).put((Object)FROM_HASH, (Object)this.fromHash).put((Object)REF_ID, (Object)this.refId).put((Object)REMOVED_COMMIT_IDS, this.removedCommitIds).put((Object)TO_HASH, (Object)this.toHash).put((Object)TOTAL_ADDED_COMMITS, (Object)this.totalAddedCommits).put((Object)TOTAL_REMOVED_COMMITS, (Object)this.totalRemovedCommits).put((Object)REF_CHANGE_TYPE_ID, (Object)this.refChangeTypeId).build();
    }

    @Nonnull
    public List<String> getAddedCommitIds() {
        return this.addedCommitIds;
    }

    @Nonnull
    public String getFromHash() {
        return this.fromHash;
    }

    public int getRefChangeTypeId() {
        return this.refChangeTypeId;
    }

    @Nonnull
    public String getRefId() {
        return this.refId;
    }

    @Nonnull
    public List<String> getRemovedCommitIds() {
        return this.removedCommitIds;
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    public int getTotalAddedCommits() {
        return this.totalAddedCommits;
    }

    public int getTotalRemovedCommits() {
        return this.totalRemovedCommits;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<String> addedCommitIds = ImmutableList.builder();
        private final ImmutableList.Builder<String> removedCommitIds = ImmutableList.builder();
        private String fromHash;
        private String refId;
        private String toHash;
        private int totalAddedCommits;
        private int totalRemovedCommits;
        private Integer refChangeTypeId;

        @Nonnull
        public Builder addedCommitIds(@Nonnull Iterable<String> values) {
            Builder.addIf(Objects::nonNull, this.addedCommitIds, values);
            return this;
        }

        @Nonnull
        public DetailedRefChangeData build() {
            return new DetailedRefChangeData(this);
        }

        @Nonnull
        public Builder fromHash(String value) {
            this.fromHash = Objects.requireNonNull(value, DetailedRefChangeData.FROM_HASH);
            return this;
        }

        @Nonnull
        public Builder refChangeTypeId(int value) {
            this.refChangeTypeId = value;
            return this;
        }

        @Nonnull
        public Builder refId(@Nonnull String value) {
            this.refId = Objects.requireNonNull(value, DetailedRefChangeData.REF_ID);
            return this;
        }

        @Nonnull
        public Builder removedCommitIds(@Nonnull Iterable<String> values) {
            Builder.addIf(Objects::nonNull, this.removedCommitIds, values);
            return this;
        }

        @Nonnull
        public Builder toHash(String value) {
            this.toHash = Objects.requireNonNull(value, DetailedRefChangeData.TO_HASH);
            return this;
        }

        @Nonnull
        public Builder totalAddedCommits(int value) {
            this.totalAddedCommits = value;
            return this;
        }

        @Nonnull
        public Builder totalRemovedCommits(int value) {
            this.totalRemovedCommits = value;
            return this;
        }
    }
}

