/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.batch;

import com.atlassian.bitbucket.repository.DetailedRefChange;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.notification.repository.push.DetailedRefChangeSoyMapper;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PushContext {
    private final List<Map<String, Object>> changes;
    private final boolean hasExtraRefChanges;
    private final ApplicationUser pusher;

    private PushContext(Builder builder) {
        this.changes = (List)builder.detailedRefChanges.build().stream().map(DetailedRefChangeSoyMapper::transform).collect(MoreCollectors.toImmutableList());
        this.hasExtraRefChanges = builder.hasExtraRefChanges;
        this.pusher = builder.pusher;
    }

    @Nonnull
    public List<Map<String, Object>> getChanges() {
        return this.changes;
    }

    @Nonnull
    public ApplicationUser getPusher() {
        return this.pusher;
    }

    public boolean hasExtraRefChanges() {
        return this.hasExtraRefChanges;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<DetailedRefChange> detailedRefChanges = ImmutableList.builder();
        private final ApplicationUser pusher;
        private boolean hasExtraRefChanges;

        public Builder(@Nonnull ApplicationUser value) {
            this.pusher = Objects.requireNonNull(value, "user");
        }

        @Nonnull
        public PushContext build() {
            return new PushContext(this);
        }

        @Nonnull
        public Builder detailedRefChanges(@Nonnull Iterable<DetailedRefChange> values) {
            Builder.addIf(Objects::nonNull, this.detailedRefChanges, values);
            return this;
        }

        @Nonnull
        public Builder hasExtraRefChanges(boolean value) {
            this.hasExtraRefChanges = value;
            return this;
        }
    }
}

