/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.batch;

import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RepositoryBatchId {
    private static final Pattern PATTERN = Pattern.compile("(\\d+)");
    private final int repositoryId;

    private RepositoryBatchId(int repositoryId) {
        this.repositoryId = repositoryId;
    }

    @Nonnull
    public static RepositoryBatchId of(@Nonnull Repository repository) {
        return new RepositoryBatchId(Objects.requireNonNull(repository, "repository").getId());
    }

    @Nullable
    public static RepositoryBatchId decode(@Nonnull String batchId) {
        Matcher matcher = PATTERN.matcher(batchId);
        return matcher.matches() ? new RepositoryBatchId(Integer.valueOf(batchId)) : null;
    }

    @Nonnull
    public String encode() {
        return String.valueOf(this.repositoryId);
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }
}

