/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.batch;

import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.SoyMailBuilder;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.stash.internal.notification.handlers.WatchableMailThreadHeaderTransformer;
import com.atlassian.stash.internal.notification.repository.batch.BatchRepositoryNotificationContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.function.Function;

public class RepositoryBatchRenderer {
    private static final String TEMPLATE = "bitbucketPluginNotification.internal.feature.email.emailRepositoryBatch.activities";
    private final SoyMailBuilder soyMailBuilder;

    public RepositoryBatchRenderer(SoyMailBuilder soyMailBuilder) {
        this.soyMailBuilder = soyMailBuilder;
    }

    @Nonnull
    public Iterable<MailMessage> render(@Nonnull BatchRepositoryNotificationContext context) {
        if (this.shouldSkipRendering(context)) {
            return ImmutableList.of();
        }
        Repository repository = context.getRepository();
        I18nKey subjectKey = this.createSubject(repository);
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder().put((Object)"hasMorePullRequests", (Object)context.hasMorePullRequests()).put((Object)"hasMorePullRequestStateChanges", (Object)context.hasMorePullRequestStateChanges()).put((Object)"hasMorePushActivity", (Object)context.hasMorePushActivity()).put((Object)"moduleKey", (Object)"com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles").put((Object)"maxNumberOfPullRequestsUpdated", (Object)50).put((Object)"maxNumberOfPushes", (Object)50).put((Object)"numberOfPushes", (Object)context.getNumberOfPushes()).put((Object)"numberOfPullRequestsUpdated", (Object)context.getNumberOfPullRequestsUpdated()).put((Object)"pullRequestActivityItems", context.getPullRequestActivityItems()).put((Object)"pullRequestStateChanges", context.getPullRequestStateChanges()).put((Object)"pushActivityChanges", context.getPushActivityChanges()).put((Object)"repository", (Object)repository);
        context.getDefaultBranch().ifPresent(branch -> contextBuilder.put((Object)"defaultBranch", branch));
        SoyMailMessageRequest request = new SoyMailMessageRequest.Builder().context((Map)contextBuilder.build()).cssModuleKey("com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles").messageEffector((Function)new WatchableMailThreadHeaderTransformer((Watchable)repository)).recipients((Iterable)ImmutableList.of((Object)context.getUser())).soyTemplateModuleKey("com.atlassian.bitbucket.server.bitbucket-notification:notification-email-templates").soyTemplateName(TEMPLATE).subjectKey(subjectKey).build();
        return this.soyMailBuilder.build(request);
    }

    private I18nKey createSubject(Repository repository) {
        String firstPlaceHolder = (String)repository.getProject().accept((ProjectVisitor)new ProjectVisitor<String>(this){

            public String visit(@Nonnull Project project) {
                return project.getName();
            }

            public String visit(@Nonnull PersonalProject project) {
                return project.getOwner().getDisplayName();
            }
        });
        return new I18nKey("bitbucket.notification.email.repository.watching.subject.batch", new Object[]{firstPlaceHolder, repository.getName()});
    }

    private boolean shouldSkipRendering(BatchRepositoryNotificationContext context) {
        return context.getPushActivityChanges().size() + context.getPullRequestActivityItems().size() + context.getPullRequestStateChanges().size() == 0;
    }
}

