/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.batch;

import com.atlassian.bitbucket.mail.MailQueueFullException;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.mail.MailSizeExceededException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.stash.internal.notification.batch.BatchNotificationAccumulator;
import com.atlassian.stash.internal.notification.batch.BatchSender;
import com.atlassian.stash.internal.notification.batch.RepositoryBatchNotificationAccumulator;
import com.atlassian.stash.internal.notification.batch.dao.UserNotification;
import com.atlassian.stash.internal.notification.repository.batch.BatchRepositoryNotificationContext;
import com.atlassian.stash.internal.notification.repository.batch.BatchRepositoryNotificationContextFactory;
import com.atlassian.stash.internal.notification.repository.batch.RepositoryBatchId;
import com.atlassian.stash.internal.notification.repository.batch.RepositoryBatchRenderer;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryBatchSender
implements BatchSender {
    public static final String ID = "Repository";
    private static final Logger log = LoggerFactory.getLogger(RepositoryBatchSender.class);
    private final BatchRepositoryNotificationContextFactory batchRepositoryNotificationContextFactory;
    private final MailService mailService;
    private final PermissionService permissionService;
    private final RepositoryBatchRenderer repositoryBatchRenderer;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;

    public RepositoryBatchSender(BatchRepositoryNotificationContextFactory batchRepositoryNotificationContextFactory, MailService mailService, PermissionService permissionService, RepositoryBatchRenderer repositoryBatchRenderer, RepositoryService repositoryService, SecurityService securityService) {
        this.batchRepositoryNotificationContextFactory = batchRepositoryNotificationContextFactory;
        this.mailService = mailService;
        this.permissionService = permissionService;
        this.repositoryBatchRenderer = repositoryBatchRenderer;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
    }

    @Override
    public BatchNotificationAccumulator createAccumulator(@Nonnull BatchNotificationAccumulator.Callback callback) {
        return new RepositoryBatchNotificationAccumulator(callback);
    }

    @Override
    @Nonnull
    public String getId() {
        return ID;
    }

    @Override
    public boolean send(@Nonnull String batchId, @Nonnull ApplicationUser user, @Nonnull Set<UserNotification> notifications) {
        Objects.requireNonNull(batchId, "batchId");
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(notifications, "notifications");
        if (!this.mailService.isHostConfigured()) {
            return false;
        }
        Repository repository = this.getRepository(batchId);
        if (repository == null) {
            return true;
        }
        try {
            return (Boolean)this.securityService.impersonating(user, "Sending batched repository notifications for user").call(() -> {
                if (!this.checkHasPermission(user, repository)) {
                    log.info("{}: Dropping {} notification(s) for {} ({}); insufficient permissions", new Object[]{repository, notifications.size(), user.getName(), user.getId()});
                    return true;
                }
                BatchRepositoryNotificationContext context = this.batchRepositoryNotificationContextFactory.createContext(repository, user, notifications);
                this.repositoryBatchRenderer.render(context).forEach(arg_0 -> ((MailService)this.mailService).submit(arg_0));
                if (log.isDebugEnabled()) {
                    log.debug("{}: Sent {} notification(s) for {} ({})", new Object[]{repository, notifications.size(), user.getName(), user.getId()});
                }
                return true;
            });
        }
        catch (MailQueueFullException e) {
            return false;
        }
        catch (MailSizeExceededException e) {
            log.info("{}: Dropping {} notification(s) for {} ({}); the message is too large ({} > {})", new Object[]{repository, notifications.size(), user.getName(), user.getId(), e.getSize(), e.getMaxSize()});
            return true;
        }
        catch (Exception e) {
            log.error("{}: Dropping {} notification(s) for {} ({}); sending failed", new Object[]{repository, notifications.size(), user.getName(), user.getId(), e});
            return true;
        }
    }

    private boolean checkHasPermission(ApplicationUser user, Repository repository) {
        return this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER) && this.permissionService.hasRepositoryPermission(user, repository, Permission.REPO_READ);
    }

    private Repository getRepository(String batchId) {
        return (Repository)this.securityService.withPermission(Permission.REPO_READ, "Retrieving repository to send batch emails").call(() -> this.repositoryService.getById(Objects.requireNonNull(RepositoryBatchId.decode(batchId), "no repositoryId in BatchId").getRepositoryId()));
    }
}

