/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.batch;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.stash.internal.notification.batch.Data;
import com.atlassian.stash.internal.notification.repository.batch.DetailedRefChangeData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RepositoryUpdateData
extends Data {
    private static final String DETAILED_REF_CHANGES = "detailedChanges";
    private static final String HAS_EXTRA_REF_CHANGES = "hasExtraRefChanges";
    private static final String PUSHING_USER_ID = "pushingUserId";
    private final List<DetailedRefChangeData> detailedRefChanges;
    private final boolean hasExtraRefChanges;
    private final int pushingUserId;

    private RepositoryUpdateData(@Nonnull Builder builder) {
        this.detailedRefChanges = builder.detailedRefChanges.build();
        this.hasExtraRefChanges = builder.hasExtraRefChanges;
        this.pushingUserId = builder.pushingUserId;
    }

    @Nullable
    public static RepositoryUpdateData tryDecode(Map<String, ?> map) {
        Object detailedRefChanges = map.get(DETAILED_REF_CHANGES);
        Object hasExtraRefChanges = map.get(HAS_EXTRA_REF_CHANGES);
        Object pushingUserId = map.get(PUSHING_USER_ID);
        if (detailedRefChanges instanceof Iterable && hasExtraRefChanges instanceof Boolean && pushingUserId instanceof Integer) {
            return new Builder().detailedRefChanges((Iterable)MoreStreams.streamIterable((Iterable)((Iterable)detailedRefChanges)).map(DetailedRefChangeData::decode).collect(MoreCollectors.toImmutableList())).hasExtraRefChanges((Boolean)hasExtraRefChanges).pushingUserId((Integer)pushingUserId).build();
        }
        return null;
    }

    @Override
    public String encode() throws IOException {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)DETAILED_REF_CHANGES, this.detailedRefChanges.stream().map(DetailedRefChangeData::encode).collect(MoreCollectors.toImmutableList())).put((Object)HAS_EXTRA_REF_CHANGES, (Object)this.hasExtraRefChanges).put((Object)PUSHING_USER_ID, (Object)this.pushingUserId);
        return DATA_MAPPER.write((Map<String, ?>)builder.build());
    }

    @Nonnull
    public List<DetailedRefChangeData> getDetailedRefChanges() {
        return this.detailedRefChanges;
    }

    public boolean hasExtraRefChanges() {
        return this.hasExtraRefChanges;
    }

    public int getPushingUserId() {
        return this.pushingUserId;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<DetailedRefChangeData> detailedRefChanges = ImmutableList.builder();
        private boolean hasExtraRefChanges;
        private int pushingUserId;

        @Nonnull
        public RepositoryUpdateData build() {
            return new RepositoryUpdateData(this);
        }

        @Nonnull
        public Builder detailedRefChanges(@Nonnull Iterable<DetailedRefChangeData> values) {
            Builder.addIf(Objects::nonNull, this.detailedRefChanges, values);
            return this;
        }

        @Nonnull
        public Builder hasExtraRefChanges(boolean value) {
            this.hasExtraRefChanges = value;
            return this;
        }

        @Nonnull
        public Builder pushingUserId(int value) {
            this.pushingUserId = value;
            return this;
        }
    }
}

