/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.notification.repository.dao.AoRepositoryNotificationSettings;
import com.atlassian.stash.internal.notification.repository.dao.MinimalRepositoryNotificationSettings;
import com.atlassian.stash.internal.notification.repository.dao.RepositoryNotificationSettingsDao;
import com.atlassian.stash.internal.notification.repository.dao.RepositoryNotificationSettingsSearchCriteria;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AoRepositoryNotificationSettingsDao
extends AbstractAoDao
implements RepositoryNotificationSettingsDao {
    private static final Logger log = LoggerFactory.getLogger(AoRepositoryNotificationSettings.class);
    private static final String REPOSITORY_CLAUSE = "REPO_ID = ?";
    private static final String USER_AND_REPO_CLAUSE = "REPO_ID = ? AND USER_ID = ?";
    private static final String USER_AND_REPO_CLAUSE_DUPLICATES = "REPO_ID = ? AND USER_ID = ? AND ID != ?";
    private static final String USER_CLAUSE = "USER_ID = ?";

    public AoRepositoryNotificationSettingsDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    public boolean delete(int repositoryId, int userId) {
        return this.ao.deleteWithSQL(AoRepositoryNotificationSettings.class, USER_AND_REPO_CLAUSE, new Object[]{repositoryId, userId}) > 0;
    }

    @Override
    public void deleteByRepository(int repositoryId) {
        this.ao.deleteWithSQL(AoRepositoryNotificationSettings.class, REPOSITORY_CLAUSE, new Object[]{repositoryId});
    }

    @Override
    public void deleteByUser(int userId) {
        this.ao.deleteWithSQL(AoRepositoryNotificationSettings.class, USER_CLAUSE, new Object[]{userId});
    }

    @Override
    @Nonnull
    public Set<PushNotificationScope> filterScopesByRepositoryId(int repositoryId, @Nonnull Set<PushNotificationScope> scopes) {
        return (Set)scopes.stream().filter(scope -> this.isScopeUsedInRepo((PushNotificationScope)((Object)scope), repositoryId)).collect(MoreCollectors.toImmutableSet());
    }

    @Override
    @Nonnull
    public Optional<MinimalRepositoryNotificationSettings> getByRepositoryAndUser(int repositoryId, int userId) {
        return this.getSettings(repositoryId, userId).map(this::toMinimalNotificationSettings);
    }

    @Override
    @Nonnull
    public MinimalRepositoryNotificationSettings saveOrUpdate(int repositoryId, int userId, @Nonnull PullRequestNotificationScope pullRequestScope, @Nonnull PushNotificationScope pushScope) {
        return this.toMinimalNotificationSettings(this.getSettings(repositoryId, userId).map(settings -> {
            settings.setPullRequestNotificationScope(pullRequestScope.getId());
            settings.setPushNotificationScope(pushScope.getId());
            settings.save();
            return settings;
        }).orElseGet(() -> (AoRepositoryNotificationSettings)this.ao.create(AoRepositoryNotificationSettings.class, (Map)ImmutableMap.builder().put((Object)"PR_NOTIFICATION_SCOPE", (Object)pullRequestScope.getId()).put((Object)"PUSH_NOTIFICATION_SCOPE", (Object)pushScope.getId()).put((Object)"USER_ID", (Object)userId).put((Object)"REPO_ID", (Object)repositoryId).build())));
    }

    @Override
    @Nonnull
    public Page<MinimalRepositoryNotificationSettings> search(@Nonnull RepositoryNotificationSettingsSearchCriteria criteria, @Nonnull PageRequest pageRequest) {
        StringJoiner where = new StringJoiner(" AND ");
        ImmutableList.Builder parameters = ImmutableList.builder();
        criteria.getRepositoryId().ifPresent(id -> {
            where.add(REPOSITORY_CLAUSE);
            parameters.add(id);
        });
        criteria.getUserId().ifPresent(id -> {
            where.add(USER_CLAUSE);
            parameters.add(id);
        });
        Set<PullRequestNotificationScope> pullRequestScopes = criteria.getPullRequestNotificationScopes();
        Set<PushNotificationScope> pushScopes = criteria.getPushNotificationScopes();
        StringJoiner scopeClause = new StringJoiner(" OR ", "(", ")");
        if (!pullRequestScopes.isEmpty()) {
            scopeClause.add(AoRepositoryNotificationSettingsDao.getScopeClause("PR_NOTIFICATION_SCOPE", pullRequestScopes.size()));
            parameters.addAll((Iterable)pullRequestScopes.stream().map(PullRequestNotificationScope::getId).collect(MoreCollectors.toImmutableSet()));
        }
        if (!pushScopes.isEmpty()) {
            scopeClause.add(AoRepositoryNotificationSettingsDao.getScopeClause("PUSH_NOTIFICATION_SCOPE", pushScopes.size()));
            parameters.addAll((Iterable)pushScopes.stream().map(PushNotificationScope::getId).collect(MoreCollectors.toImmutableSet()));
        }
        if (scopeClause.length() > 2) {
            where.add(scopeClause.toString());
        }
        Query query = Query.select();
        if (where.length() > 0) {
            query.where(where.toString(), parameters.build().toArray());
        }
        query.order("USER_ID, REPO_ID ASC");
        return this.pageQuery(AoRepositoryNotificationSettings.class, query, pageRequest).transform(this::toMinimalNotificationSettings);
    }

    private static String getScopeClause(String column, int numberOfScopes) {
        return String.format("%s IN (%s)", column, StringUtils.repeat((String)"?", (String)",", (int)numberOfScopes));
    }

    private Optional<AoRepositoryNotificationSettings> getSettings(int repositoryId, int userId) {
        AoRepositoryNotificationSettings[] settings = (AoRepositoryNotificationSettings[])this.ao.find(AoRepositoryNotificationSettings.class, Query.select().where(USER_AND_REPO_CLAUSE, new Object[]{repositoryId, userId}));
        Optional<AoRepositoryNotificationSettings> maybeSettings = Arrays.stream(settings).findFirst();
        maybeSettings.ifPresent(s -> {
            if (settings.length > 1) {
                log.warn("Found multiple entries for user {} and repository {}. Duplicates will be deleted", (Object)userId, (Object)repositoryId);
                this.ao.deleteWithSQL(AoRepositoryNotificationSettings.class, USER_AND_REPO_CLAUSE_DUPLICATES, new Object[]{repositoryId, userId, s.getID()});
            }
        });
        return maybeSettings;
    }

    private boolean isScopeUsedInRepo(PushNotificationScope scope, int repositoryId) {
        Query filterQuery = Query.select().where("REPO_ID = ? AND PUSH_NOTIFICATION_SCOPE = ?", new Object[]{repositoryId, scope.getId()});
        return this.ao.count(AoRepositoryNotificationSettings.class, filterQuery) > 0;
    }

    private MinimalRepositoryNotificationSettings toMinimalNotificationSettings(AoRepositoryNotificationSettings settings) {
        return new MinimalRepositoryNotificationSettings.Builder(settings.getRepositoryId(), settings.getUserId()).pullRequestNotificationScope(PullRequestNotificationScope.fromId(settings.getPullRequestNotificationScope())).pushRequestNotificationScope(PushNotificationScope.fromId(settings.getPushNotificationScope())).build();
    }
}

