/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.dao;

import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class MinimalRepositoryNotificationSettings {
    private final PullRequestNotificationScope pullRequestNotificationScope;
    private final PushNotificationScope pushNotificationScope;
    private final int repositoryId;
    private final int userId;

    private MinimalRepositoryNotificationSettings(@Nonnull Builder builder) {
        this.pullRequestNotificationScope = builder.pullRequestScope;
        this.pushNotificationScope = builder.pushScope;
        this.repositoryId = builder.repositoryId;
        this.userId = builder.userId;
    }

    @Nonnull
    public PullRequestNotificationScope getPullRequestNotificationScope() {
        return this.pullRequestNotificationScope;
    }

    @Nonnull
    public PushNotificationScope getPushNotificationScope() {
        return this.pushNotificationScope;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public int getUserId() {
        return this.userId;
    }

    public static class Builder {
        private final int repositoryId;
        private final int userId;
        private PullRequestNotificationScope pullRequestScope;
        private PushNotificationScope pushScope;

        public Builder(int repositoryId, int userId) {
            this.repositoryId = repositoryId;
            this.userId = userId;
            this.pullRequestScope = PullRequestNotificationScope.NONE;
            this.pushScope = PushNotificationScope.NONE;
        }

        @Nonnull
        public MinimalRepositoryNotificationSettings build() {
            return new MinimalRepositoryNotificationSettings(this);
        }

        @Nonnull
        public Builder pullRequestNotificationScope(@Nonnull PullRequestNotificationScope value) {
            this.pullRequestScope = Objects.requireNonNull(value, "pullRequestNotificationScope");
            return this;
        }

        @Nonnull
        public Builder pushRequestNotificationScope(@Nonnull PushNotificationScope value) {
            this.pushScope = Objects.requireNonNull(value, "pushRequestNotificationScope");
            return this;
        }
    }
}

