/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.dao;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsSearchRequest;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class RepositoryNotificationSettingsSearchCriteria {
    private final Set<PullRequestNotificationScope> pullRequestNotificationScopes;
    private final Set<PushNotificationScope> pushNotificationScopes;
    private final Integer repositoryId;
    private final Integer userId;

    private RepositoryNotificationSettingsSearchCriteria(Builder builder) {
        this.pullRequestNotificationScopes = builder.pullRequestNotificationScopes.build();
        this.pushNotificationScopes = builder.pushNotificationScopes.build();
        this.repositoryId = builder.repositoryId;
        this.userId = builder.userId;
    }

    @Nonnull
    public Set<PullRequestNotificationScope> getPullRequestNotificationScopes() {
        return this.pullRequestNotificationScopes;
    }

    @Nonnull
    public Set<PushNotificationScope> getPushNotificationScopes() {
        return this.pushNotificationScopes;
    }

    @Nonnull
    public Optional<Integer> getRepositoryId() {
        return Optional.ofNullable(this.repositoryId);
    }

    @Nonnull
    public Optional<Integer> getUserId() {
        return Optional.ofNullable(this.userId);
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<PullRequestNotificationScope> pullRequestNotificationScopes;
        private final ImmutableSet.Builder<PushNotificationScope> pushNotificationScopes;
        private Integer repositoryId;
        private Integer userId;

        public Builder() {
            this.pullRequestNotificationScopes = ImmutableSet.builder();
            this.pushNotificationScopes = ImmutableSet.builder();
        }

        public Builder(@Nonnull RepositoryNotificationSettingsSearchRequest request) {
            Objects.requireNonNull(request, "request");
            this.pullRequestNotificationScopes = ImmutableSet.builder();
            this.pushNotificationScopes = ImmutableSet.builder();
            this.pullRequestNotificationScopes(request.getPullRequestNotificationScopes());
            this.pushNotificationScopes(request.getPushNotificationScopes());
            this.repositoryId = request.getRepository().map(Repository::getId).orElse(null);
            this.userId = request.getUser().map(ApplicationUser::getId).orElse(null);
        }

        @Nonnull
        public RepositoryNotificationSettingsSearchCriteria build() {
            return new RepositoryNotificationSettingsSearchCriteria(this);
        }

        @Nonnull
        public Builder pullRequestNotificationScopes(@Nonnull Iterable<PullRequestNotificationScope> values) {
            Builder.addIf(Objects::nonNull, this.pullRequestNotificationScopes, values);
            return this;
        }

        @Nonnull
        public Builder pushNotificationScopes(@Nonnull Iterable<PushNotificationScope> values) {
            Builder.addIf(Objects::nonNull, this.pushNotificationScopes, values);
            return this;
        }

        @Nonnull
        public Builder repositoryId(@Nullable Integer value) {
            this.repositoryId = value;
            return this;
        }

        @Nonnull
        public Builder userId(@Nullable Integer value) {
            this.userId = value;
            return this;
        }
    }
}

