/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.annotation.InternalAuditable;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.stash.internal.notification.audit.RepositoryNotificationsUpdatedEventConverter;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

@AsynchronousPreferred
@InternalAuditable(actionI18nKey="bitbucket.notification.audit.action.repositorynotificationsettingsupdated", categoryI18nKey="bitbucket.service.audit.category.repositories", converter=RepositoryNotificationsUpdatedEventConverter.class, coverageArea=CoverageArea.END_USER_ACTIVITY, coverageLevel=CoverageLevel.FULL)
@EventName(value="stash.notification.repository.settings.updated")
@TransactionAware
public class RepositoryNotificationSettingsUpdatedEvent
extends ApplicationEvent {
    private final RepositoryNotificationSettings previousSettings;
    private final RepositoryNotificationSettings settings;

    public RepositoryNotificationSettingsUpdatedEvent(@Nonnull Object source, @Nonnull RepositoryNotificationSettings settings, @Nullable RepositoryNotificationSettings previousSettings) {
        super(source);
        this.settings = Objects.requireNonNull(settings, "settings");
        this.previousSettings = previousSettings;
    }

    @Nonnull
    public Optional<RepositoryNotificationSettings> getPreviousSettings() {
        return Optional.ofNullable(this.previousSettings);
    }

    @Nonnull
    public PullRequestNotificationScope getPullRequestNotificationScope() {
        return this.settings.getPullRequestNotificationScope();
    }

    @Nonnull
    public PushNotificationScope getPushNotificationScope() {
        return this.settings.getPushNotificationScope();
    }

    @Nonnull
    public Repository getRepository() {
        return this.settings.getRepository();
    }

    @Nonnull
    public ApplicationUser getSettingsUser() {
        return this.settings.getUser();
    }
}

