/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.handler;

import com.atlassian.bitbucket.dmz.notification.Notification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestCommentNotification;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.stash.internal.notification.handlers.NotificationMailer;
import com.atlassian.stash.internal.notification.mention.MentionHelper;
import com.atlassian.stash.internal.notification.repository.handler.PullRequestRepositoryNotificationHandler;
import com.atlassian.stash.internal.notification.repository.handler.RepositoryNotificationRecipientHelper;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCommentRepositoryNotificationHandler<T extends PullRequestCommentNotification>
extends PullRequestRepositoryNotificationHandler<T> {
    private static final String TEMPLATE_NAME = "bitbucketPluginNotification.internal.feature.email.emailRepository.comment";
    private final MentionHelper mentionHelper;

    public AbstractCommentRepositoryNotificationHandler(NotificationMailer notificationMailer, RepositoryNotificationRecipientHelper recipientHelper, MentionHelper mentionHelper) {
        super(TEMPLATE_NAME, notificationMailer, recipientHelper);
        this.mentionHelper = mentionHelper;
    }

    @Override
    protected Iterable<ApplicationUser> getRecipients(T notification, Set<Watcher> watchers) {
        Iterable<ApplicationUser> recipients = super.getRecipients(notification, watchers);
        return (Iterable)this.mentionHelper.getFilteredRecipientsAndMentions((Notification)notification, notification.getComment(), recipients).left();
    }

    @Override
    protected Map<String, Object> getContext(T notification) {
        Map<String, Object> context = super.getContext(notification);
        context.put("comment", notification.getComment());
        return context;
    }
}

