/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.handler;

import com.atlassian.bitbucket.dmz.notification.pull.PullRequestFromRefRescopedNotification;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.stash.internal.notification.handlers.NotificationMailer;
import com.atlassian.stash.internal.notification.pull.handlers.PullRequestNotificationHelper;
import com.atlassian.stash.internal.notification.repository.handler.PullRequestRepositoryNotificationHandler;
import com.atlassian.stash.internal.notification.repository.handler.RepositoryNotificationRecipientHelper;
import java.util.Map;

public class PullRequestFromRefRescopedRepositoryNotificationHandler
extends PullRequestRepositoryNotificationHandler<PullRequestFromRefRescopedNotification> {
    private static final int MAX_COMMITS_ON_RESCOPE = 5;
    private static final String TEMPLATE_NAME = "bitbucketPluginNotification.internal.feature.email.emailRepository.rescoped";
    private final PullRequestNotificationHelper notificationHelper;

    public PullRequestFromRefRescopedRepositoryNotificationHandler(PullRequestNotificationHelper notificationHelper, NotificationMailer notificationMailer, RepositoryNotificationRecipientHelper recipientHelper) {
        super(TEMPLATE_NAME, notificationMailer, recipientHelper);
        this.notificationHelper = notificationHelper;
    }

    @Override
    protected Map<String, Object> getContext(PullRequestFromRefRescopedNotification notification) {
        Map<String, Object> context = super.getContext(notification);
        context.put("commits", this.notificationHelper.getNewCommits(notification.getPullRequest(), notification.getPreviousFromHash(), 5));
        return context;
    }

    @Override
    protected void renderAndSend(PullRequestFromRefRescopedNotification notification, SoyMailMessageRequest messageRequest) {
        if (PullRequestFromRefRescopedRepositoryNotificationHandler.hasNewCommits(messageRequest.getContext())) {
            super.renderAndSend(notification, messageRequest);
        }
    }

    private static boolean hasNewCommits(Map<String, Object> context) {
        Page commits = (Page)context.get("commits");
        return commits == PullRequestNotificationHelper.THROTTLED || commits.getSize() > 0;
    }
}

