/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.handler;

import com.atlassian.bitbucket.dmz.notification.NotificationHandler;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestNotification;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.stash.internal.notification.handlers.NotificationMailer;
import com.atlassian.stash.internal.notification.handlers.WatchableMailThreadHeaderTransformer;
import com.atlassian.stash.internal.notification.pull.PullRequestNotificationUtils;
import com.atlassian.stash.internal.notification.repository.handler.RepositoryNotificationRecipientHelper;
import com.atlassian.stash.internal.notification.repository.handler.RepositoryNotificationSettingsFilterParameters;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class PullRequestRepositoryNotificationHandler<T extends PullRequestNotification>
implements NotificationHandler<T> {
    private final String templateName;
    private final NotificationMailer notificationMailer;
    private final RepositoryNotificationRecipientHelper recipientHelper;

    public PullRequestRepositoryNotificationHandler(String templateName, NotificationMailer notificationMailer, RepositoryNotificationRecipientHelper recipientHelper) {
        this.templateName = templateName;
        this.notificationMailer = notificationMailer;
        this.recipientHelper = recipientHelper;
    }

    public void handle(@Nonnull T notification, @Nonnull Set<Watcher> watchers) {
        PullRequest pullRequest = this.getPullRequest(notification);
        SoyMailMessageRequest messageRequest = new SoyMailMessageRequest.Builder().context(this.getContext(notification)).cssModuleKey("com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles").messageEffector((Function)new WatchableMailThreadHeaderTransformer((Watchable)pullRequest)).recipients(this.getRecipients(notification, watchers)).soyTemplateModuleKey("com.atlassian.bitbucket.server.bitbucket-notification:notification-email-templates").soyTemplateName(this.templateName).subjectKey(PullRequestNotificationUtils.createSubjectKey(pullRequest)).build();
        this.renderAndSend(notification, messageRequest);
    }

    protected Map<String, Object> getContext(T notification) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("date", notification.getTimestamp());
        context.put("moduleKey", "com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles");
        context.put("user", notification.getUser());
        context.put("pullRequest", notification.getPullRequest());
        context.put("batchable", true);
        return context;
    }

    protected Iterable<ApplicationUser> getRecipients(T notification, Set<Watcher> watchers) {
        RepositoryNotificationSettingsFilterParameters parameters = new RepositoryNotificationSettingsFilterParameters.Builder(this.getRepository(notification)).pullRequestNotificationScope(PullRequestNotificationScope.ALL).sendModes(SendMode.immediateSet()).watchers(watchers).build();
        return (Iterable)this.recipientHelper.findSettings(parameters).stream().map(RepositoryNotificationSettings::getUser).collect(MoreCollectors.toImmutableSet());
    }

    protected Repository getRepository(T notification) {
        return notification.getPullRequest().getToRef().getRepository();
    }

    protected PullRequest getPullRequest(T notification) {
        return notification.getPullRequest();
    }

    protected void renderAndSend(T notification, SoyMailMessageRequest messageRequest) {
        this.notificationMailer.renderAndSend(notification, messageRequest);
    }
}

