/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.handler;

import com.atlassian.bitbucket.dmz.notification.NotificationHandler;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestMergedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestNotification;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.stash.internal.notification.handlers.NotificationMailer;
import com.atlassian.stash.internal.notification.handlers.WatchableMailThreadHeaderTransformer;
import com.atlassian.stash.internal.notification.pull.PullRequestNotificationUtils;
import com.atlassian.stash.internal.notification.repository.handler.RepositoryNotificationRecipientHelper;
import com.atlassian.stash.internal.notification.repository.handler.RepositoryNotificationSettingsFilterParameters;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PullRequestStateChangeRepositoryNotificationHandler
implements NotificationHandler<PullRequestNotification> {
    private final NotificationMailer notificationMailer;
    private final RepositoryNotificationRecipientHelper recipientHelper;
    private final String templateName;

    public PullRequestStateChangeRepositoryNotificationHandler(NotificationMailer notificationMailer, RepositoryNotificationRecipientHelper recipientHelper, String templateName) {
        this.notificationMailer = notificationMailer;
        this.recipientHelper = recipientHelper;
        this.templateName = templateName;
    }

    public void handle(@Nonnull PullRequestNotification notification, @Nonnull Set<Watcher> watchers) {
        Repository repository = notification.getPullRequest().getToRef().getRepository();
        this.getRecipientsByScope(watchers, repository).forEach((scope, recipients) -> this.sendMessage(notification, (PullRequestNotificationScope)((Object)scope), (Set<ApplicationUser>)recipients));
    }

    private Map<String, Object> getContext(PullRequestNotification notification) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"date", (Object)notification.getTimestamp()).put((Object)"moduleKey", (Object)"com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles").put((Object)"user", (Object)notification.getUser()).put((Object)"pullRequest", (Object)notification.getPullRequest()).put((Object)"batchable", (Object)true);
        if (notification instanceof PullRequestMergedNotification) {
            builder.put((Object)"autoMerge", (Object)((PullRequestMergedNotification)notification).isAutoMerge());
        }
        return builder.build();
    }

    private Map<PullRequestNotificationScope, Set<ApplicationUser>> getRecipientsByScope(Set<Watcher> watchers, Repository repository) {
        try (Timer ignored = TimerUtils.start((String)"Getting repository notification settings for watchers");){
            RepositoryNotificationSettingsFilterParameters parameters = new RepositoryNotificationSettingsFilterParameters.Builder(repository).pullRequestNotificationScope(PullRequestNotificationScope.ALL).pullRequestNotificationScope(PullRequestNotificationScope.STATE_CHANGES).sendModes(SendMode.immediateSet()).watchers(watchers).build();
            Map<PullRequestNotificationScope, Set<ApplicationUser>> map = this.recipientHelper.findSettings(parameters).stream().collect(Collectors.groupingBy(RepositoryNotificationSettings::getPullRequestNotificationScope, Collectors.mapping(RepositoryNotificationSettings::getUser, MoreCollectors.toImmutableSet())));
            return map;
        }
    }

    private SoyMailMessageRequest.Builder newBuilder(Map<String, Object> context, Set<ApplicationUser> recipients) {
        return new SoyMailMessageRequest.Builder().context(context).cssModuleKey("com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles").recipients(recipients).soyTemplateModuleKey("com.atlassian.bitbucket.server.bitbucket-notification:notification-email-templates").soyTemplateName(this.templateName);
    }

    private void sendMessage(PullRequestNotification notification, PullRequestNotificationScope scope, Set<ApplicationUser> recipients) {
        if (scope == PullRequestNotificationScope.ALL) {
            PullRequest pullRequest = notification.getPullRequest();
            this.notificationMailer.renderAndSend(notification, this.newBuilder(this.getContext(notification), recipients).messageEffector((Function)new WatchableMailThreadHeaderTransformer((Watchable)pullRequest)).subjectKey(PullRequestNotificationUtils.createSubjectKey(pullRequest)).build());
        } else if (scope == PullRequestNotificationScope.STATE_CHANGES) {
            Repository repository = notification.getPullRequest().getToRef().getRepository();
            this.notificationMailer.renderAndSend(notification, this.newBuilder(this.getContext(notification), recipients).messageEffector((Function)new WatchableMailThreadHeaderTransformer((Watchable)repository)).subjectKey(new I18nKey("bitbucket.notification.email.repository.watching.subject.state.changes", new Object[]{repository.getProject().getName(), repository.getName()})).build());
        }
    }
}

