/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.handler;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsSearchRequest;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsService;
import com.atlassian.stash.internal.notification.repository.handler.RepositoryNotificationSettingsFilterParameters;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.EmailNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.atlassian.stash.internal.notification.usersettings.SendSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettingsService;
import jakarta.annotation.Nonnull;
import java.util.Set;

public class RepositoryNotificationRecipientHelper {
    private final RepositoryNotificationSettingsService repositoryNotificationSettingsService;
    private final SecurityService securityService;
    private final UserNotificationSettingsService userNotificationSettingsService;

    public RepositoryNotificationRecipientHelper(@Nonnull RepositoryNotificationSettingsService repositoryNotificationSettingsService, @Nonnull SecurityService securityService, @Nonnull UserNotificationSettingsService userNotificationSettingsService) {
        this.repositoryNotificationSettingsService = repositoryNotificationSettingsService;
        this.securityService = securityService;
        this.userNotificationSettingsService = userNotificationSettingsService;
    }

    @Nonnull
    public Set<RepositoryNotificationSettings> findSettings(@Nonnull RepositoryNotificationSettingsFilterParameters parameters) {
        try (Timer ignored = TimerUtils.start((String)"Getting repository notification settings for watchers");){
            Set watchingUsers = (Set)parameters.getWatchers().stream().map(Watcher::getUser).collect(MoreCollectors.toImmutableSet());
            RepositoryNotificationSettingsSearchRequest request = new RepositoryNotificationSettingsSearchRequest.Builder().pullRequestNotificationScopes(parameters.getPullRequestNotificationScopes()).repository(parameters.getRepository()).build();
            Set set = (Set)PageUtils.toStream(page -> this.repositoryNotificationSettingsService.search(request, page), (int)50).filter(settings -> this.needsUpdate((RepositoryNotificationSettings)settings, parameters.getSendModes())).filter(settings -> watchingUsers.contains(settings.getUser())).collect(MoreCollectors.toImmutableSet());
            return set;
        }
    }

    private boolean needsUpdate(RepositoryNotificationSettings settings, Set<SendMode> sendModes) {
        try (Timer ignored = TimerUtils.start((String)("Getting repository sendModeSettings for user " + settings.getUser().toString()));){
            ApplicationUser recipient = settings.getUser();
            boolean bl = (Boolean)this.securityService.impersonating(recipient, "notification handling").call(() -> this.userNotificationSettingsService.getSettingsForUser(recipient).getEmailNotificationSettings().flatMap(EmailNotificationSettings::getRepositorySendModeSettings).map(SendSettings::getSendMode).filter(sendModes::contains).isPresent());
            return bl;
        }
    }
}

