/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.handler;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.watcher.WatchableVisitor;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.stash.internal.notification.repository.IsRepositoryWatchableVisitor;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class RepositoryNotificationSettingsFilterParameters {
    private final Set<PullRequestNotificationScope> pullRequestNotificationScopes;
    private final Repository repository;
    private final Set<SendMode> sendModes;
    private final List<Watcher> watchers;

    private RepositoryNotificationSettingsFilterParameters(Builder builder) {
        this.pullRequestNotificationScopes = builder.pullRequestNotificationScopes.build();
        this.repository = builder.repository;
        this.sendModes = builder.sendModes.build();
        this.watchers = builder.watchers.build();
    }

    @Nonnull
    public Set<PullRequestNotificationScope> getPullRequestNotificationScopes() {
        return this.pullRequestNotificationScopes;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public Set<SendMode> getSendModes() {
        return this.sendModes;
    }

    @Nonnull
    public List<Watcher> getWatchers() {
        return this.watchers;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<PullRequestNotificationScope> pullRequestNotificationScopes;
        private final Repository repository;
        private final ImmutableSet.Builder<SendMode> sendModes;
        private final ImmutableList.Builder<Watcher> watchers;

        public Builder(@Nonnull Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.pullRequestNotificationScopes = ImmutableSet.builder();
            this.sendModes = ImmutableSet.builder();
            this.watchers = ImmutableList.builder();
        }

        @Nonnull
        public RepositoryNotificationSettingsFilterParameters build() {
            return new RepositoryNotificationSettingsFilterParameters(this);
        }

        @Nonnull
        public Builder pullRequestNotificationScope(@Nonnull PullRequestNotificationScope value) {
            Builder.addIf(Objects::nonNull, this.pullRequestNotificationScopes, (Object)((Object)value));
            return this;
        }

        @Nonnull
        public Builder pullRequestNotificationScopes(@Nonnull Iterable<PullRequestNotificationScope> values) {
            Builder.addIf(Objects::nonNull, this.pullRequestNotificationScopes, values);
            return this;
        }

        @Nonnull
        public Builder sendMode(@Nonnull SendMode value) {
            Builder.addIf(Objects::nonNull, this.sendModes, (Object)((Object)value));
            return this;
        }

        @Nonnull
        public Builder sendModes(@Nonnull Iterable<SendMode> values) {
            Builder.addIf(Objects::nonNull, this.sendModes, values);
            return this;
        }

        @Nonnull
        public Builder watchers(@Nonnull Iterable<Watcher> values) {
            Builder.addIf(watcher -> watcher != null && (Boolean)watcher.getWatchable().accept((WatchableVisitor)new IsRepositoryWatchableVisitor()) != false, this.watchers, values);
            return this;
        }
    }
}

