/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.model;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class SimpleRepositoryNotificationSettings
implements RepositoryNotificationSettings {
    private final MinimalRef defaultBranch;
    private final PullRequestNotificationScope pullRequestScope;
    private final PushNotificationScope pushScope;
    private final Repository repository;
    private final ApplicationUser user;

    private SimpleRepositoryNotificationSettings(@Nonnull Builder builder) {
        this.defaultBranch = Objects.requireNonNull(builder.defaultBranch, "defaultBranch");
        this.pullRequestScope = Objects.requireNonNull(builder.pullRequestScope, "pullRequestNotificationScope");
        this.pushScope = Objects.requireNonNull(builder.pushScope, "pushNotificationScope");
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.user = Objects.requireNonNull(builder.user, "user");
    }

    @Override
    @Nonnull
    public MinimalRef getDefaultBranch() {
        return this.defaultBranch;
    }

    @Override
    @Nonnull
    public PullRequestNotificationScope getPullRequestNotificationScope() {
        return this.pullRequestScope;
    }

    @Override
    @Nonnull
    public PushNotificationScope getPushNotificationScope() {
        return this.pushScope;
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    public static class Builder {
        private final Repository repository;
        private final ApplicationUser user;
        private MinimalRef defaultBranch;
        private PullRequestNotificationScope pullRequestScope;
        private PushNotificationScope pushScope;

        public Builder(@Nonnull Repository repository, @Nonnull ApplicationUser user) {
            this.user = user;
            this.repository = repository;
        }

        @Nonnull
        public SimpleRepositoryNotificationSettings build() {
            return new SimpleRepositoryNotificationSettings(this);
        }

        @Nonnull
        public Builder pullRequestNotificationScope(@Nonnull PullRequestNotificationScope value) {
            this.pullRequestScope = value;
            return this;
        }

        @Nonnull
        public Builder pushNotificationScope(@Nonnull PushNotificationScope value) {
            this.pushScope = value;
            return this;
        }

        @Nonnull
        public Builder defaultBranch(@Nonnull MinimalRef value) {
            this.defaultBranch = value;
            return this;
        }
    }
}

