/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.push;

import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.dmz.notification.NotificationHandler;
import com.atlassian.bitbucket.dmz.notification.repository.RepositoryPushNotification;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.repository.DetailedRefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.notification.batch.dao.UserNotificationDao;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsSearchRequest;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsService;
import com.atlassian.stash.internal.notification.repository.batch.DetailedRefChangeData;
import com.atlassian.stash.internal.notification.repository.batch.RepositoryBatchId;
import com.atlassian.stash.internal.notification.repository.batch.RepositoryUpdateData;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.atlassian.stash.internal.notification.usersettings.EmailNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.atlassian.stash.internal.notification.usersettings.SendSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettingsService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedRepositoryPushNotificationHandler
implements NotificationHandler<RepositoryPushNotification> {
    private static final Logger log = LoggerFactory.getLogger(BatchedRepositoryPushNotificationHandler.class);
    private final MailService mailService;
    private final RepositoryNotificationSettingsService repositoryNotificationSettingsService;
    private final TransactionTemplate transactionTemplate;
    private final UserNotificationDao userNotificationDao;
    private final UserNotificationSettingsService userNotificationSettingsService;

    private BatchedRepositoryPushNotificationHandler(MailService mailService, RepositoryNotificationSettingsService repositoryNotificationSettingsService, TransactionTemplate transactionTemplate, UserNotificationDao userNotificationDao, UserNotificationSettingsService userNotificationSettingsService) {
        this.mailService = mailService;
        this.repositoryNotificationSettingsService = repositoryNotificationSettingsService;
        this.transactionTemplate = transactionTemplate;
        this.userNotificationDao = userNotificationDao;
        this.userNotificationSettingsService = userNotificationSettingsService;
    }

    public void handle(@Nonnull RepositoryPushNotification notification, @Nonnull Set<Watcher> watchers) {
        if (!this.mailService.isHostConfigured()) {
            log.debug("No mail configuration: discarding {} details: {}", (Object)notification.getClass().getSimpleName(), (Object)notification);
            return;
        }
        Objects.requireNonNull(notification, "notification");
        Set watchingUsers = (Set)watchers.stream().map(Watcher::getUser).collect(MoreCollectors.toImmutableSet());
        try (Timer ignored = TimerUtils.start((String)("Adding notification to batch " + notification.getClass().getName()));){
            Map<PushNotificationScope, String> dataByScope = BatchedRepositoryPushNotificationHandler.getDataByScope(notification);
            Date date = notification.getTimestamp();
            Repository repository = notification.getRepository();
            RepositoryNotificationSettingsSearchRequest searchRequest = new RepositoryNotificationSettingsSearchRequest.Builder().repository(repository).pushNotificationScopes(dataByScope.keySet()).build();
            PageUtils.toStream(page -> this.repositoryNotificationSettingsService.search(searchRequest, page), (int)500).filter(settings -> this.isBatchRecipient(settings.getUser()) && watchingUsers.contains(settings.getUser())).forEach(settings -> this.transactionTemplate.execute(() -> this.userNotificationDao.create(settings.getUser().getId(), date, "Repository", RepositoryBatchId.of(repository).encode(), (String)dataByScope.get((Object)settings.getPushNotificationScope()))));
        }
    }

    private static Map<PushNotificationScope, String> getDataByScope(RepositoryPushNotification notification) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        notification.getDefaultBranchChange().ifPresent(change -> BatchedRepositoryPushNotificationHandler.toEncodedData(notification, (Collection<DetailedRefChange>)ImmutableList.of((Object)change)).ifPresent(data -> builder.put((Object)PushNotificationScope.DEFAULT_BRANCH, data)));
        BatchedRepositoryPushNotificationHandler.toEncodedData(notification, notification.getRefChanges()).ifPresent(data -> builder.put((Object)PushNotificationScope.ALL, data));
        return builder.build();
    }

    private static DetailedRefChangeData toDetailedRefChange(DetailedRefChange refChange) {
        return new DetailedRefChangeData.Builder().addedCommitIds(Iterables.transform((Iterable)refChange.getAdded().getCommits(), MinimalCommit::getId)).fromHash(refChange.getFromHash()).refId(refChange.getRef().getId()).removedCommitIds(Iterables.transform((Iterable)refChange.getRemoved().getCommits(), MinimalCommit::getId)).totalAddedCommits(refChange.getAdded().getTotal()).totalRemovedCommits(refChange.getRemoved().getTotal()).toHash(refChange.getToHash()).refChangeTypeId(refChange.getType().getId()).build();
    }

    private static Optional<String> toEncodedData(RepositoryPushNotification notification, Collection<DetailedRefChange> refChanges) {
        try {
            return Optional.of(new RepositoryUpdateData.Builder().detailedRefChanges((Iterable)refChanges.stream().map(BatchedRepositoryPushNotificationHandler::toDetailedRefChange).collect(MoreCollectors.toImmutableSet())).hasExtraRefChanges(notification.hasExtraRefChanges()).pushingUserId(Objects.requireNonNull(notification.getUser(), "RepositoryPushNotification has no user").getId()).build().encode());
        }
        catch (IOException e) {
            log.warn("Failed to encode data for notification", (Throwable)e);
            return Optional.empty();
        }
    }

    private boolean isBatchRecipient(ApplicationUser user) {
        try (Timer ignored = TimerUtils.start((String)("Check send mode for user " + String.valueOf(user)));){
            boolean bl = SendMode.BATCHED == this.userNotificationSettingsService.getSettingsForUser(user).getEmailNotificationSettings().flatMap(EmailNotificationSettings::getRepositorySendModeSettings).map(SendSettings::getSendMode).orElseGet(this.userNotificationSettingsService::getDefaultSendMode);
            return bl;
        }
    }
}

