/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.push;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.repository.DetailedRefChange;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.SimpleDetailedRefChange;
import com.atlassian.bitbucket.repository.SimpleRefChangeDetails;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DetailedRefChangeBuilder {
    private static final int COMMITS_PER_REF_LIMIT = 5;
    private final List<Commit> commitsAdded;
    private final List<Commit> commitsRemoved;
    private final RefChange refChange;
    private int totalCommitsAdded;
    private int totalCommitsRemoved;

    public DetailedRefChangeBuilder(@Nonnull RefChange refChange) {
        this.refChange = refChange;
        this.commitsAdded = new ArrayList<Commit>(5);
        this.commitsRemoved = new ArrayList<Commit>(5);
    }

    @Nonnull
    public DetailedRefChangeBuilder commitAdded(@Nonnull Commit commit) {
        Objects.requireNonNull(commit, "commit");
        if (this.totalCommitsAdded < 5) {
            this.commitsAdded.add(commit);
        }
        ++this.totalCommitsAdded;
        return this;
    }

    @Nonnull
    public DetailedRefChangeBuilder commitRemoved(@Nonnull Commit commit) {
        Objects.requireNonNull(commit, "commit");
        if (this.totalCommitsRemoved < 5) {
            this.commitsRemoved.add(commit);
        }
        ++this.totalCommitsRemoved;
        return this;
    }

    @Nonnull
    public DetailedRefChange build() {
        return new SimpleDetailedRefChange.Builder(this.refChange).added(new SimpleRefChangeDetails.Builder().commits(this.commitsAdded).totalCommits(this.totalCommitsAdded).build()).removed(new SimpleRefChangeDetails.Builder().commits(this.commitsRemoved).totalCommits(this.totalCommitsRemoved).build()).build();
    }
}

