/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.push;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.repository.DetailedRefChange;
import com.atlassian.bitbucket.repository.RefChangeDetails;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DetailedRefChangeSoyMapper {
    public static Map<String, Object> transform(@Nonnull DetailedRefChange refChange) {
        Objects.requireNonNull(refChange, "refChange");
        return new ImmutableMap.Builder().put((Object)"to", (Object)refChange.getToHash()).put((Object)"from", (Object)refChange.getFromHash()).put((Object)"ref", (Object)refChange.getRef()).put((Object)"added", DetailedRefChangeSoyMapper.transformRefChangeDetails(refChange.getAdded())).put((Object)"removed", DetailedRefChangeSoyMapper.transformRefChangeDetails(refChange.getRemoved())).build();
    }

    private static Map<String, Object> transformCommit(Commit commit) {
        return new ImmutableMap.Builder().put((Object)"author", (Object)commit.getAuthor()).put((Object)"displayId", (Object)commit.getDisplayId()).put((Object)"id", (Object)commit.getId()).put((Object)"comitter", (Object)commit.getCommitter()).put((Object)"message", (Object)(StringUtils.isEmpty((CharSequence)commit.getMessage()) ? "" : commit.getMessage())).put((Object)"AuthorTimestamp", (Object)commit.getAuthorTimestamp()).build();
    }

    private static List<Map<String, Object>> transformCommits(List<Commit> commitList) {
        return commitList.stream().map(DetailedRefChangeSoyMapper::transformCommit).collect(Collectors.toList());
    }

    private static Map<String, Object> transformRefChangeDetails(RefChangeDetails refChangeDetails) {
        return new ImmutableMap.Builder().put((Object)"total", (Object)refChangeDetails.getTotal()).put((Object)"commits", DetailedRefChangeSoyMapper.transformCommits(refChangeDetails.getCommits())).build();
    }
}

