/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.push;

import com.atlassian.bitbucket.dmz.notification.NotificationHandler;
import com.atlassian.bitbucket.dmz.notification.repository.RepositoryPushNotification;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.DetailedRefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.stash.internal.notification.handlers.NotificationMailer;
import com.atlassian.stash.internal.notification.handlers.WatchableMailThreadHeaderTransformer;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsSearchRequest;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsService;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.atlassian.stash.internal.notification.repository.push.DetailedRefChangeSoyMapper;
import com.atlassian.stash.internal.notification.usersettings.EmailNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.atlassian.stash.internal.notification.usersettings.SendSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettingsService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ImmediateRepositoryPushNotificationHandler
implements NotificationHandler<RepositoryPushNotification> {
    private static final int BATCH_SIZE = 1000;
    private static final String PROP_SUBJECT_KEY = "bitbucket.email.repository.pushed.changes.subject";
    private static final String TEMPLATE_NAME = "bitbucketPluginNotification.internal.feature.email.emailRepository.pushed";
    private final NotificationMailer notificationMailer;
    private final PermissionService permissionService;
    private final RepositoryNotificationSettingsService repoNotificationSettingsService;
    private final UserNotificationSettingsService userNotificationSettingsService;

    public ImmediateRepositoryPushNotificationHandler(NotificationMailer notificationMailer, PermissionService permissionService, RepositoryNotificationSettingsService repoNotificationSettingsService, UserNotificationSettingsService userNotificationSettingsService) {
        this.notificationMailer = notificationMailer;
        this.permissionService = permissionService;
        this.repoNotificationSettingsService = repoNotificationSettingsService;
        this.userNotificationSettingsService = userNotificationSettingsService;
    }

    public void handle(@Nonnull RepositoryPushNotification notification, @Nonnull Set<Watcher> watchers) {
        Objects.requireNonNull(notification, "notification");
        try (Timer ignored = TimerUtils.start((String)("Sending notification " + notification.getClass().getName()));){
            Repository repository = notification.getRepository();
            Map<PushNotificationScope, Collection<DetailedRefChange>> changesByScope = ImmediateRepositoryPushNotificationHandler.getChangesByScope(notification);
            this.getSettings(repository, changesByScope.keySet()).filter(s -> {
                ApplicationUser user = s.getUser();
                return this.isLicensedUser(user) && this.isImmediateRecipient(user) && this.canReadRepository(user, repository) && watchers.stream().anyMatch(watcher -> user.equals((Object)watcher.getUser()));
            }).collect(Collectors.groupingBy(RepositoryNotificationSettings::getPushNotificationScope)).forEach((scope, settings) -> this.notificationMailer.renderAndSend(notification, new SoyMailMessageRequest.Builder().cssModuleKey("com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles").recipients(Iterables.transform((Iterable)settings, RepositoryNotificationSettings::getUser)).subjectKey(ImmediateRepositoryPushNotificationHandler.getSubjectKey(repository)).soyTemplateModuleKey("com.atlassian.bitbucket.server.bitbucket-notification:notification-email-templates").soyTemplateName(TEMPLATE_NAME).context(ImmediateRepositoryPushNotificationHandler.getContext(notification, (Collection)changesByScope.get(scope))).messageEffector((Function)new WatchableMailThreadHeaderTransformer((Watchable)repository)).build()));
        }
    }

    private static Map<PushNotificationScope, Collection<DetailedRefChange>> getChangesByScope(RepositoryPushNotification notification) {
        return (Map)notification.getDefaultBranch().flatMap(defaultBranch -> notification.getRefChanges().stream().filter(refChange -> refChange.getRef().getId().equals(defaultBranch.getId())).findFirst()).map(defaultBranchChange -> ImmutableMap.builder().put((Object)PushNotificationScope.ALL, (Object)notification.getRefChanges()).put((Object)PushNotificationScope.DEFAULT_BRANCH, Collections.singletonList(defaultBranchChange)).build()).orElseGet(() -> ImmutableMap.of((Object)((Object)PushNotificationScope.ALL), (Object)notification.getRefChanges()));
    }

    private static Map<String, Object> getContext(RepositoryPushNotification notification, Collection<DetailedRefChange> changes) {
        return ImmutableMap.builder().put((Object)"changes", changes.stream().map(DetailedRefChangeSoyMapper::transform).collect(MoreCollectors.toImmutableList())).put((Object)"repository", (Object)notification.getRepository()).put((Object)"hasExtraRefChanges", (Object)notification.hasExtraRefChanges()).put((Object)"user", (Object)notification.getUser()).put((Object)"moduleKey", (Object)"com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles").build();
    }

    private static I18nKey getSubjectKey(Repository repository) {
        return new I18nKey(PROP_SUBJECT_KEY, new Object[]{repository.getProject().getName(), repository.getName()});
    }

    private boolean canReadRepository(ApplicationUser user, Repository repository) {
        return this.permissionService.hasRepositoryPermission(user, repository, Permission.REPO_READ);
    }

    private Stream<RepositoryNotificationSettings> getSettings(Repository repository, Set<PushNotificationScope> scopes) {
        return PageUtils.toStream(pageRequest -> this.repoNotificationSettingsService.search(new RepositoryNotificationSettingsSearchRequest.Builder().repository(repository).pushNotificationScopes(scopes).build(), pageRequest), (int)1000);
    }

    private boolean isImmediateRecipient(ApplicationUser user) {
        try (Timer ignored = TimerUtils.start((String)("Check send mode for user " + String.valueOf(user)));){
            boolean bl = SendMode.IMMEDIATE == this.userNotificationSettingsService.getSettingsForUser(user).getEmailNotificationSettings().flatMap(EmailNotificationSettings::getRepositorySendModeSettings).map(SendSettings::getSendMode).orElseGet(this.userNotificationSettingsService::getDefaultSendMode);
            return bl;
        }
    }

    private boolean isLicensedUser(ApplicationUser user) {
        return this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER);
    }
}

