/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.push;

import com.atlassian.bitbucket.hook.repository.PostRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitFilter;
import com.atlassian.bitbucket.hook.repository.RepositoryPushHookRequest;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsService;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.atlassian.stash.internal.notification.repository.push.RepositoryHookNotificationCallbackFactory;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class PushNotificationHook
implements PostRepositoryHook<RepositoryPushHookRequest> {
    private final RepositoryHookNotificationCallbackFactory callbackFactory;
    private final RefService refService;
    private final RepositoryNotificationSettingsService repositoryNotificationSettingsService;

    public PushNotificationHook(RepositoryHookNotificationCallbackFactory callbackFactory, RefService refService, RepositoryNotificationSettingsService repositoryNotificationSettingsService) {
        this.callbackFactory = callbackFactory;
        this.refService = refService;
        this.repositoryNotificationSettingsService = repositoryNotificationSettingsService;
    }

    public void postUpdate(@Nonnull PostRepositoryHookContext context, @Nonnull RepositoryPushHookRequest request) {
        Repository repository = request.getRepository();
        Collection refChanges = request.getRefChanges();
        Branch defaultBranch = this.getDefaultBranch(repository);
        RefChange defaultRefChange = defaultBranch == null ? null : (RefChange)refChanges.stream().filter(refChange -> defaultBranch.getId().equals(refChange.getRef().getId())).findFirst().orElse(null);
        Set<PushNotificationScope> scopes = this.getScopesInUse(repository, defaultRefChange);
        if (scopes.isEmpty()) {
            return;
        }
        Collection<RefChange> filteredChanges = this.getFilteredChanges(scopes, refChanges, defaultRefChange);
        if (filteredChanges.isEmpty()) {
            return;
        }
        context.registerCommitCallback((RepositoryHookCommitCallback)this.callbackFactory.create(repository, defaultBranch, filteredChanges), RepositoryHookCommitFilter.ADDED_TO_REPOSITORY, new RepositoryHookCommitFilter[]{RepositoryHookCommitFilter.REMOVED_FROM_REPOSITORY});
    }

    private Branch getDefaultBranch(Repository repository) {
        try {
            return this.refService.getDefaultBranch(repository);
        }
        catch (NoDefaultBranchException ignored) {
            return null;
        }
    }

    private Collection<RefChange> getFilteredChanges(Set<PushNotificationScope> scopes, Collection<RefChange> refChanges, RefChange defaultRefChange) {
        if (scopes.contains((Object)PushNotificationScope.ALL)) {
            return refChanges;
        }
        return defaultRefChange == null ? Collections.emptySet() : Collections.singleton(defaultRefChange);
    }

    private Set<PushNotificationScope> getScopesInUse(Repository repository, RefChange defaultChange) {
        EnumSet<PushNotificationScope> scopes = defaultChange == null ? EnumSet.of(PushNotificationScope.ALL) : EnumSet.of(PushNotificationScope.ALL, PushNotificationScope.DEFAULT_BRANCH);
        return this.repositoryNotificationSettingsService.filterScopesByRepository(repository, scopes);
    }
}

