/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.push;

import com.atlassian.bitbucket.dmz.notification.Notification;
import com.atlassian.bitbucket.dmz.notification.NotificationHandler;
import com.atlassian.bitbucket.dmz.notification.repository.RepositoryPushNotification;
import com.atlassian.bitbucket.hook.repository.CommitAddedDetails;
import com.atlassian.bitbucket.hook.repository.CommitRemovedDetails;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitCallback;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.bitbucket.watcher.WatcherSearchRequest;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.stash.internal.notification.repository.push.DetailedRefChangeBuilder;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryHookNotificationCallback
implements RepositoryHookCommitCallback {
    private static final int BATCH_SIZE = 1000;
    private static final int REFS_PER_NOTIFICATION_LIMIT = 10;
    private static final Logger log = LoggerFactory.getLogger(RepositoryHookNotificationCallback.class);
    private final Map<MinimalRef, DetailedRefChangeBuilder> buildersByRef;
    private final Map<MinimalRef, RefChange> changesByRef;
    private final ApplicationUser currentUser;
    private final Branch defaultBranch;
    private final ExecutorService executorService;
    private final List<NotificationHandler<RepositoryPushNotification>> handlers;
    private final Repository repository;
    private final WatcherService watcherService;
    private boolean hasExtraRefChanges;

    public RepositoryHookNotificationCallback(ApplicationUser currentUser, Branch defaultBranch, ExecutorService executorService, List<NotificationHandler<RepositoryPushNotification>> handlers, Collection<RefChange> refChanges, Repository repository, WatcherService watcherService) {
        this.currentUser = currentUser;
        this.defaultBranch = defaultBranch;
        this.executorService = executorService;
        this.handlers = handlers;
        this.repository = repository;
        this.watcherService = watcherService;
        this.buildersByRef = new HashMap<MinimalRef, DetailedRefChangeBuilder>();
        this.changesByRef = (Map)refChanges.stream().collect(MoreCollectors.toImmutableMap(RefChange::getRef, Function.identity()));
    }

    public boolean onCommitAdded(@Nonnull CommitAddedDetails commitDetails) {
        this.getDetailedRefChangeBuilder(commitDetails.getRef()).ifPresent(builder -> builder.commitAdded(commitDetails.getCommit()));
        return true;
    }

    public boolean onCommitRemoved(@Nonnull CommitRemovedDetails commitDetails) {
        this.getDetailedRefChangeBuilder(commitDetails.getRef()).ifPresent(builder -> builder.commitRemoved(commitDetails.getCommit()));
        return true;
    }

    public void onEnd() {
        if (this.buildersByRef.isEmpty()) {
            return;
        }
        this.executorService.execute(() -> {
            Set<Watcher> watchers = this.getWatchers();
            if (watchers.isEmpty()) {
                return;
            }
            RepositoryPushNotification notification = new RepositoryPushNotification(this.currentUser, new Date(), this.repository, this.defaultBranch, this.hasExtraRefChanges, (Collection)this.buildersByRef.values().stream().map(DetailedRefChangeBuilder::build).collect(MoreCollectors.toImmutableList()));
            this.handlers.forEach(handler -> {
                try {
                    handler.handle((Notification)notification, watchers);
                }
                catch (Exception e) {
                    log.warn("{} failed to handle notification {}", handler, (Object)notification);
                }
            });
        });
    }

    private Optional<DetailedRefChangeBuilder> getDetailedRefChangeBuilder(MinimalRef ref) {
        RefChange change = this.changesByRef.get(ref);
        if (change == null) {
            return Optional.empty();
        }
        if (this.buildersByRef.size() == 10) {
            DetailedRefChangeBuilder refChange = this.buildersByRef.get(ref);
            if (refChange == null) {
                this.hasExtraRefChanges = true;
            }
            return Optional.ofNullable(refChange);
        }
        return Optional.of(this.buildersByRef.computeIfAbsent(ref, r -> new DetailedRefChangeBuilder(change)));
    }

    private Set<Watcher> getWatchers() {
        return (Set)PageUtils.toStream(pageRequest -> this.watcherService.search(new WatcherSearchRequest.Builder((Watchable)this.repository).build(), pageRequest), (int)1000).filter(watcher -> !watcher.getUser().equals((Object)this.currentUser)).collect(MoreCollectors.toImmutableSet());
    }
}

