/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.repository.push;

import com.atlassian.bitbucket.dmz.notification.repository.RepositoryPushNotification;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.repository.DetailedRefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.bitbucket.watcher.WatcherSearchRequest;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.stash.internal.notification.handlers.NotificationMailer;
import com.atlassian.stash.internal.notification.handlers.WatchableMailThreadHeaderTransformer;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsSearchRequest;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsService;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.atlassian.stash.internal.notification.repository.push.DetailedRefChangeSoyMapper;
import com.atlassian.stash.internal.notification.usersettings.EmailNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.atlassian.stash.internal.notification.usersettings.SendSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettingsService;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class RepositoryPushNotificationDispatcher {
    private static final String TEMPLATE_NAME = "bitbucketPluginNotification.internal.feature.email.emailRepository.pushed";
    private static final int BATCH_SIZE = 100;
    private final NotificationMailer notificationMailer;
    private final RepositoryNotificationSettingsService repositoryNotificationSettingsService;
    private final UserNotificationSettingsService userNotificationSettingsService;
    private final WatcherService watcherService;

    public RepositoryPushNotificationDispatcher(NotificationMailer notificationMailer, RepositoryNotificationSettingsService repositoryNotificationSettingsService, UserNotificationSettingsService userNotificationSettingsService, WatcherService watcherService) {
        this.notificationMailer = notificationMailer;
        this.repositoryNotificationSettingsService = repositoryNotificationSettingsService;
        this.userNotificationSettingsService = userNotificationSettingsService;
        this.watcherService = watcherService;
    }

    public void dispatch(@Nonnull RepositoryPushNotification notification) {
        try (Timer ignored = TimerUtils.start((String)"Dispatching RepositoryPushNotification");){
            Objects.requireNonNull(notification, "notification");
            Repository repository = notification.getRepository();
            DetailedRefChange defaultBranchChange = notification.getDefaultBranch().flatMap(defaultBranch -> notification.getRefChanges().stream().filter(refChange -> refChange.getRef().getId().equals(defaultBranch.getId())).findFirst()).orElse(null);
            ImmutableMap<PushNotificationScope, Collection<DetailedRefChange>> changesByScope = RepositoryPushNotificationDispatcher.getChangesByScope(notification, defaultBranchChange);
            Set watchingUsers = (Set)PageUtils.toStream(pageRequest -> this.watcherService.search(new WatcherSearchRequest.Builder((Watchable)repository).build(), pageRequest), (int)100).map(Watcher::getUser).collect(MoreCollectors.toImmutableSet());
            RepositoryNotificationSettingsSearchRequest searchRequest = new RepositoryNotificationSettingsSearchRequest.Builder().repository(repository).pushNotificationScopes(changesByScope.keySet()).build();
            PageUtils.toStream(pageRequest -> this.repositoryNotificationSettingsService.search(searchRequest, pageRequest), (int)100).filter(settings -> this.userNeedsUpdate(notification, watchingUsers, settings.getUser())).collect(Collectors.groupingBy(RepositoryNotificationSettings::getPushNotificationScope, Collectors.mapping(RepositoryNotificationSettings::getUser, MoreCollectors.toImmutableSet()))).forEach((key, value) -> this.sendMail((Set<ApplicationUser>)value, notification, (Collection)changesByScope.get(key)));
        }
    }

    private static I18nKey getSubjectKey(Repository repository) {
        return new I18nKey("bitbucket.email.repository.pushed.changes.subject", new Object[]{repository.getProject().getName(), repository.getName()});
    }

    private static ImmutableMap<PushNotificationScope, Collection<DetailedRefChange>> getChangesByScope(RepositoryPushNotification notification, DetailedRefChange defaultBranchChange) {
        return defaultBranchChange == null ? ImmutableMap.of((Object)((Object)PushNotificationScope.ALL), (Object)notification.getRefChanges()) : ImmutableMap.of((Object)((Object)PushNotificationScope.ALL), (Object)notification.getRefChanges(), (Object)((Object)PushNotificationScope.DEFAULT_BRANCH), Collections.singletonList(defaultBranchChange));
    }

    private static Map<String, Object> getTemplateData(Collection<DetailedRefChange> changes, boolean hasExtraRefChanges, Repository repository, ApplicationUser user) {
        return ImmutableMap.builder().put((Object)"changes", RepositoryPushNotificationDispatcher.mapChanges(changes)).put((Object)"hasExtraRefChanges", (Object)hasExtraRefChanges).put((Object)"repository", (Object)repository).put((Object)"user", (Object)user).put((Object)"moduleKey", (Object)"com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles").build();
    }

    private static List<Map<String, Object>> mapChanges(Collection<DetailedRefChange> changes) {
        return (List)changes.stream().map(DetailedRefChangeSoyMapper::transform).collect(MoreCollectors.toImmutableList());
    }

    private boolean hasImmediateUpdate(ApplicationUser user) {
        try (Timer ignored = TimerUtils.start((String)("Getting repository sendModeSettings for a user " + user.toString()));){
            UserNotificationSettings settings = this.userNotificationSettingsService.getSettingsForUser(user);
            boolean bl = settings.getEmailNotificationSettings().flatMap(EmailNotificationSettings::getRepositorySendModeSettings).map(SendSettings::getSendMode).orElse(null) == SendMode.IMMEDIATE;
            return bl;
        }
    }

    private void sendMail(Set<ApplicationUser> receivers, RepositoryPushNotification notification, Collection<DetailedRefChange> changes) {
        Repository repository = notification.getRepository();
        this.notificationMailer.renderAndSend(notification, receivers, RepositoryPushNotificationDispatcher.getSubjectKey(repository), TEMPLATE_NAME, RepositoryPushNotificationDispatcher.getTemplateData(changes, notification.hasExtraRefChanges(), repository, notification.getUser()), new WatchableMailThreadHeaderTransformer((Watchable)repository));
    }

    private boolean userNeedsUpdate(RepositoryPushNotification notification, Set<ApplicationUser> watchingUsers, ApplicationUser user) {
        return watchingUsers.contains(user) && this.hasImmediateUpdate(user) && !user.equals((Object)notification.getUser());
    }
}

