/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.stash.internal.notification.batch.BatchNotificationJob;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Path(value="batch")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class BatchNotificationResource {
    private final BatchNotificationJob batchNotificationJob;
    private final PermissionService permissionService;

    @Inject
    public BatchNotificationResource(BatchNotificationJob batchNotificationJob, PermissionService permissionService) {
        this.batchNotificationJob = batchNotificationJob;
        this.permissionService = permissionService;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getNotificationCount() {
        if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            return ResponseFactory.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ImmutableMap count = ImmutableMap.of((Object)"count", (Object)this.batchNotificationJob.notificationCount());
        return ResponseFactory.ok((Object)count).build();
    }

    @POST
    @Path(value="process")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response processBatchNotifications(@DefaultValue(value="0") @QueryParam(value="time") long time) {
        if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            return ResponseFactory.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (time == 0L) {
            this.batchNotificationJob.processAllSenders();
        } else {
            this.batchNotificationJob.processAllSenders(time);
        }
        return ResponseFactory.noContent().build();
    }
}

