/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.stash.internal.notification.rest.RestSendSettings;
import com.atlassian.stash.internal.notification.usersettings.EmailNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.atlassian.stash.internal.notification.usersettings.SendSettings;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nullable;
import java.util.Map;

@JsonSerialize
@JsonSurrogate(value=EmailNotificationSettings.class)
public class RestEmailNotificationSettings
extends RestMapEntity {
    private static final String REPOSITORY_NOTIFICATIONS = "repositoryNotifications";
    private static final String PULL_REQUEST_NOTIFICATIONS = "pullRequestNotifications";

    public RestEmailNotificationSettings() {
    }

    public RestEmailNotificationSettings(EmailNotificationSettings emailNotificationSettings) {
        emailNotificationSettings.getRepositorySendModeSettings().ifPresent(settings -> this.put(REPOSITORY_NOTIFICATIONS, (Object)new RestSendSettings((SendSettings)settings)));
        emailNotificationSettings.getPullRequestSendModeSettings().ifPresent(settings -> this.put(PULL_REQUEST_NOTIFICATIONS, (Object)new RestSendSettings((SendSettings)settings)));
    }

    private RestEmailNotificationSettings(Map<String, ?> values) {
        super(values);
    }

    public static RestEmailNotificationSettings valueOf(@Nullable Object value, @Nullable SendMode sendMode) {
        if (value instanceof RestEmailNotificationSettings) {
            return (RestEmailNotificationSettings)((Object)value);
        }
        if (value instanceof Map) {
            return new RestEmailNotificationSettings((Map)value);
        }
        if (sendMode != null) {
            RestEmailNotificationSettings settings = new RestEmailNotificationSettings();
            settings.put(PULL_REQUEST_NOTIFICATIONS, (Object)new RestSendSettings(sendMode));
            return settings;
        }
        return null;
    }

    public RestSendSettings getRepositoryNotifications() {
        return RestSendSettings.valueOf(this.get(REPOSITORY_NOTIFICATIONS));
    }

    public RestSendSettings getPullRequestNotifications() {
        return RestSendSettings.valueOf(this.get(PULL_REQUEST_NOTIFICATIONS));
    }
}

