/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.stash.internal.notification.rest.RestEmailNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.EmailNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.atlassian.stash.internal.notification.usersettings.SendSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettings;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSurrogate(value=UserNotificationSettings.class)
@JsonSerialize
public class RestUserNotificationSettings
extends RestMapEntity {
    private static final String EMAIL = "email";
    private static final String SEND_MODE = "sendMode";

    public RestUserNotificationSettings(UserNotificationSettings input) {
        this.putIfNotNull(SEND_MODE, (Object)RestUserNotificationSettings.getLegacySendMode(input));
        input.getEmailNotificationSettings().ifPresent(settings -> this.put(EMAIL, (Object)new RestEmailNotificationSettings((EmailNotificationSettings)settings)));
    }

    public RestUserNotificationSettings() {
    }

    public RestEmailNotificationSettings getEmailNotificationSettings() {
        return RestEmailNotificationSettings.valueOf(this.get(EMAIL), (SendMode)this.getEnumProperty(SEND_MODE, SendMode.class));
    }

    private static SendMode getLegacySendMode(UserNotificationSettings input) {
        return input.getEmailNotificationSettings().flatMap(EmailNotificationSettings::getPullRequestSendModeSettings).map(SendSettings::getSendMode).orElse(null);
    }
}

