/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.UserResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.stash.internal.notification.rest.RestEmailNotificationSettings;
import com.atlassian.stash.internal.notification.rest.RestSendSettings;
import com.atlassian.stash.internal.notification.rest.RestUserNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettingsFactory;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettingsService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="settings")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class UserNotificationSettingsResource {
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final UserNotificationSettingsService userNotificationSettingsService;
    private final WebSudoManager webSudoManager;

    @Inject
    public UserNotificationSettingsResource(AuthenticationContext authenticationContext, I18nService i18nService, PermissionValidationService permissionValidationService, UserNotificationSettingsService userNotificationSettingsService, WebSudoManager webSudoManager) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.userNotificationSettingsService = userNotificationSettingsService;
        this.webSudoManager = webSudoManager;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUserSettingsForCurrentUser(@Context HttpServletRequest request) {
        return this.getUserSettings(this.getCurrentUserOrFail(), request);
    }

    @GET
    @Path(value="{userSlug}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUserSettings(@BeanParam UserResolver userResolver, @Context HttpServletRequest request) {
        return this.getUserSettings(userResolver.getUser(), request);
    }

    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateUserSettingsForCurrentUser(@Context HttpServletRequest request, RestUserNotificationSettings update) {
        return this.updateUserSettings(request, this.getCurrentUserOrFail(), update);
    }

    @PUT
    @Path(value="{userSlug}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateUserSettings(@Context HttpServletRequest request, @BeanParam UserResolver userResolver, RestUserNotificationSettings update) {
        return this.updateUserSettings(request, userResolver.getUser(), update);
    }

    private ApplicationUser getCurrentUserOrFail() {
        this.permissionValidationService.validateAuthenticated();
        return this.authenticationContext.getCurrentUser();
    }

    private Response getUserSettings(ApplicationUser user, HttpServletRequest request) {
        if (!user.equals((Object)this.authenticationContext.getCurrentUser())) {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        }
        UserNotificationSettings settings = this.userNotificationSettingsService.getSettingsForUser(user);
        return ResponseFactory.ok((Object)((Object)new RestUserNotificationSettings(settings))).build();
    }

    private Response updateUserSettings(HttpServletRequest request, ApplicationUser user, RestUserNotificationSettings update) {
        if (!user.equals((Object)this.authenticationContext.getCurrentUser())) {
            this.webSudoManager.willExecuteWebSudoRequest(request);
        }
        this.validateRequestBody(update);
        UserNotificationSettings settings = UserNotificationSettingsFactory.create(update);
        this.userNotificationSettingsService.updateSettingsForUser(user, settings);
        return ResponseFactory.noContent().build();
    }

    private void validateRequestBody(RestUserNotificationSettings settings) {
        try {
            SendMode repositorySendMode;
            RestEmailNotificationSettings mail = settings.getEmailNotificationSettings();
            if (mail == null) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.notification.rest.user.settings.invalid", new Object[0]));
            }
            RestSendSettings pullRequestNotifications = mail.getPullRequestNotifications();
            RestSendSettings repositoryNotifications = mail.getRepositoryNotifications();
            SendMode pullRequestSendMode = pullRequestNotifications == null ? null : pullRequestNotifications.getSendMode();
            SendMode sendMode = repositorySendMode = repositoryNotifications == null ? null : repositoryNotifications.getSendMode();
            if (pullRequestSendMode == null && repositorySendMode == null) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.notification.rest.user.settings.invalid", new Object[0]));
            }
        }
        catch (IllegalArgumentException ignored) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.notification.rest.user.settings.invalid.sendmode", new Object[]{Stream.of(SendMode.values()).map(Enum::name).collect(Collectors.joining(", "))}));
        }
    }
}

