/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.rest.repository;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsSearchRequest;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsService;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.atlassian.stash.internal.notification.rest.repository.RestRepositoryNotificationSettings;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="watch")
@Produces(value={"application/json"})
@Singleton
public class RepositoryNotificationsSettingsResource {
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final RepositoryNotificationSettingsService settingsService;

    @Inject
    public RepositoryNotificationsSettingsResource(AuthenticationContext authenticationContext, I18nService i18nService, PermissionValidationService permissionValidationService, RepositoryNotificationSettingsService settingsService) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.settingsService = settingsService;
    }

    @Path(value="projects/{projectKey}/repos/{repositorySlug}")
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response get(@BeanParam RepositoryResolver repositoryResolver) {
        Repository repository = repositoryResolver.getRepository();
        ApplicationUser currentUser = this.getCurrentUserOrFail();
        Optional<RepositoryNotificationSettings> settings = this.settingsService.getByRepositoryAndUser(repository, currentUser);
        return settings.map(s -> ResponseFactory.ok((Object)((Object)new RestRepositoryNotificationSettings((RepositoryNotificationSettings)s)))).orElseGet(() -> ResponseFactory.error((Response.Status)Response.Status.NOT_FOUND, null, (String)this.i18nService.getMessage("bitbucket.notification.rest.repository.settings.notfound", new Object[]{repository.getName()}))).build();
    }

    @Path(value="repos")
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAll(@BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="pullRequestNotificationScopes") Set<String> pullRequestNotificationScopes, @QueryParam(value="pushNotificationScopes") Set<String> pushNotificationScopes) {
        ApplicationUser currentUser = this.getCurrentUserOrFail();
        RepositoryNotificationSettingsSearchRequest searchRequest = new RepositoryNotificationSettingsSearchRequest.Builder().pullRequestNotificationScopes(RepositoryNotificationsSettingsResource.getPullRequestNotificationScopes(pullRequestNotificationScopes)).pushNotificationScopes(RepositoryNotificationsSettingsResource.getPushNotificationScopes(pushNotificationScopes)).user(currentUser).build();
        Page<RepositoryNotificationSettings> settingsPage = this.settingsService.search(searchRequest, pageRequestResolver.getPageRequest());
        Page transform = settingsPage.transform(RestRepositoryNotificationSettings.REST_TRANSFORM);
        return ResponseFactory.ok((Object)new RestPage(transform)).build();
    }

    @Path(value="projects/{projectKey}/repos/{repositorySlug}")
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setSettings(@BeanParam RepositoryResolver repositoryResolver, RestRepositoryNotificationSettings settings) {
        ApplicationUser currentUser = this.getCurrentUserOrFail();
        this.validateSettings(settings);
        RepositoryNotificationSettings repositoryNotificationSettings = this.settingsService.set(currentUser, repositoryResolver.getRepository(), settings.getPullRequestNotificationScope(), settings.getPushNotificationScope());
        return ResponseFactory.ok((Object)((Object)new RestRepositoryNotificationSettings(repositoryNotificationSettings))).build();
    }

    private ApplicationUser getCurrentUserOrFail() {
        this.permissionValidationService.validateAuthenticated();
        return this.authenticationContext.getCurrentUser();
    }

    private static Set<PullRequestNotificationScope> getPullRequestNotificationScopes(Set<String> scopes) {
        return (Set)scopes.stream().map(PullRequestNotificationScope::valueOf).collect(MoreCollectors.toImmutableSet());
    }

    private static Set<PushNotificationScope> getPushNotificationScopes(Set<String> scopes) {
        return (Set)scopes.stream().map(PushNotificationScope::valueOf).collect(MoreCollectors.toImmutableSet());
    }

    private void validateSettings(RestRepositoryNotificationSettings settings) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (settings.getPullRequestNotificationScope() == null) {
            errorMessages.add(this.i18nService.getMessage("bitbucket.notification.rest.repository.settings.pullrequestnotificationscope.empty", new Object[0]));
        }
        if (settings.getPushNotificationScope() == null) {
            errorMessages.add(this.i18nService.getMessage("bitbucket.notification.rest.repository.settings.pushnotificationscope.empty", new Object[0]));
        }
        if (!errorMessages.isEmpty()) {
            throw new BadRequestException(errorMessages);
        }
    }
}

