/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.rest.repository;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.repository.RestMinimalRef;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.function.Function;

@JsonSerialize
@JsonSurrogate(value=RepositoryNotificationSettings.class)
public class RestRepositoryNotificationSettings
extends RestMapEntity {
    public static final Function<RepositoryNotificationSettings, RestRepositoryNotificationSettings> REST_TRANSFORM = RestRepositoryNotificationSettings::new;
    private static final String DEFAULT_BRANCH = "defaultBranch";
    private static final String REPOSITORY = "repository";
    private static final String USER = "user";
    private static final String PULL_REQUEST_NOTIFICATION_SCOPE = "pullRequestNotificationScope";
    private static final String PUSH_NOTIFICATION_SCOPE = "pushNotificationScope";

    public RestRepositoryNotificationSettings() {
    }

    public RestRepositoryNotificationSettings(RepositoryNotificationSettings settings) {
        this(new RestApplicationUser(settings.getUser()), new RestRepository(settings.getRepository()), new RestMinimalRef(settings.getDefaultBranch()), settings.getPullRequestNotificationScope(), settings.getPushNotificationScope());
    }

    private RestRepositoryNotificationSettings(RestApplicationUser applicationUser, RestRepository repository, RestMinimalRef restBranch, PullRequestNotificationScope pullRequestNotificationScope, PushNotificationScope pushNotificationScope) {
        this.put(PUSH_NOTIFICATION_SCOPE, (Object)pushNotificationScope);
        this.put(PULL_REQUEST_NOTIFICATION_SCOPE, (Object)pullRequestNotificationScope);
        this.put(USER, applicationUser);
        this.put(REPOSITORY, repository);
        this.putIfNotNull(DEFAULT_BRANCH, restBranch);
    }

    public PullRequestNotificationScope getPullRequestNotificationScope() {
        return (PullRequestNotificationScope)this.getEnumProperty(PULL_REQUEST_NOTIFICATION_SCOPE, PullRequestNotificationScope.class);
    }

    public PushNotificationScope getPushNotificationScope() {
        return (PushNotificationScope)this.getEnumProperty(PUSH_NOTIFICATION_SCOPE, PushNotificationScope.class);
    }
}

