/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.usersettings;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.atlassian.stash.internal.notification.usersettings.EmailNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.atlassian.stash.internal.notification.usersettings.SendSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettingsFactory;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettingsService;
import com.atlassian.stash.internal.notification.usersettings.event.PullRequestNotificationSendModePreferenceChangeEvent;
import com.atlassian.stash.internal.notification.usersettings.event.RepositoryNotificationSendModePreferenceChangeEvent;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DefaultUserNotificationSettingsService
implements UserNotificationSettingsService {
    private final EventPublisher eventPublisher;
    private final PermissionValidationService permissionValidationService;
    private final UserSettingsService userSettingsService;
    private final SendMode defaultSendMode;

    public DefaultUserNotificationSettingsService(EventPublisher eventPublisher, PermissionValidationService permissionValidationService, ApplicationPropertiesService propertiesService, UserSettingsService userSettingsService) {
        this.eventPublisher = eventPublisher;
        this.permissionValidationService = permissionValidationService;
        this.userSettingsService = userSettingsService;
        this.defaultSendMode = SendMode.fromString(propertiesService.getPluginProperty("plugin.bitbucket-notification.sendmode.default", SendMode.BATCHED.name()));
    }

    @Override
    @Nonnull
    public SendMode getDefaultSendMode() {
        return this.defaultSendMode;
    }

    @Override
    @Nonnull
    public UserNotificationSettings getSettingsForUser(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        UserSettings settings = this.userSettingsService.getUserSettings(this.getUserKeyForUser(user));
        return UserNotificationSettingsFactory.create(settings, this.defaultSendMode);
    }

    @Override
    public void updateSettingsForUser(@Nonnull ApplicationUser user, @Nonnull UserNotificationSettings newSettings) {
        this.permissionValidationService.validateForUser(Objects.requireNonNull(user, "user"), Permission.USER_ADMIN);
        Objects.requireNonNull(newSettings, "newSettings");
        this.userSettingsService.updateUserSettings(this.getUserKeyForUser(user), builder -> {
            UserNotificationSettings oldSettings = UserNotificationSettingsFactory.create(builder.build(), this.defaultSendMode);
            newSettings.applyTo((UserSettingsBuilder)builder);
            this.maybePublishPreferenceChange(user, oldSettings, newSettings);
            return builder.build();
        });
    }

    private SendMode getPullRequestSendMode(UserNotificationSettings settings) {
        return settings.getEmailNotificationSettings().flatMap(EmailNotificationSettings::getPullRequestSendModeSettings).map(SendSettings::getSendMode).orElse(null);
    }

    private SendMode getRepositorySendMode(UserNotificationSettings settings) {
        return settings.getEmailNotificationSettings().flatMap(EmailNotificationSettings::getRepositorySendModeSettings).map(SendSettings::getSendMode).orElse(null);
    }

    private UserKey getUserKeyForUser(ApplicationUser user) {
        return UserKey.fromLong((long)Objects.requireNonNull(user, "user").getId());
    }

    private void maybePublishPreferenceChange(ApplicationUser user, UserNotificationSettings oldSettings, UserNotificationSettings newSettings) {
        SendMode repositorySendMode;
        SendMode pullRequestSendMode = this.getPullRequestSendMode(newSettings);
        if (pullRequestSendMode != null && !Objects.equals((Object)this.getPullRequestSendMode(oldSettings), (Object)pullRequestSendMode)) {
            this.eventPublisher.publish((Object)new PullRequestNotificationSendModePreferenceChangeEvent(this, user, pullRequestSendMode, this.defaultSendMode));
        }
        if ((repositorySendMode = this.getRepositorySendMode(newSettings)) != null && !Objects.equals((Object)this.getRepositorySendMode(oldSettings), (Object)repositorySendMode)) {
            this.eventPublisher.publish((Object)new RepositoryNotificationSendModePreferenceChangeEvent(this, user, repositorySendMode, this.defaultSendMode));
        }
    }
}

