/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.usersettings;

import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.stash.internal.notification.usersettings.SendSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;

public class EmailNotificationSettings {
    private final SendSettings pullRequestSendSettings;
    private final SendSettings repositorySendSettings;

    private EmailNotificationSettings(Builder builder) {
        this.pullRequestSendSettings = builder.pullRequestSendSettings;
        this.repositorySendSettings = builder.repositorySendSettings;
    }

    @Nonnull
    public Optional<SendSettings> getPullRequestSendModeSettings() {
        return Optional.ofNullable(this.pullRequestSendSettings);
    }

    @Nonnull
    public Optional<SendSettings> getRepositorySendModeSettings() {
        return Optional.ofNullable(this.repositorySendSettings);
    }

    public void applyTo(@Nonnull UserSettingsBuilder builder) {
        if (this.repositorySendSettings != null) {
            this.repositorySendSettings.applyTo(builder, "plugin.bitbucket-notification:email:repositoryNotificationSendMode");
        }
        if (this.pullRequestSendSettings != null) {
            this.pullRequestSendSettings.applyTo(builder, "plugin.bitbucket-notification:notificationSendMode");
        }
    }

    public static class Builder {
        private SendSettings pullRequestSendSettings;
        private SendSettings repositorySendSettings;

        @Nonnull
        public Builder repositorySendSettings(@Nullable SendSettings value) {
            this.repositorySendSettings = value;
            return this;
        }

        @Nonnull
        public Builder pullRequestSendSettings(@Nullable SendSettings value) {
            this.pullRequestSendSettings = value;
            return this;
        }

        @Nonnull
        public EmailNotificationSettings build() {
            return new EmailNotificationSettings(this);
        }
    }
}

