/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.usersettings;

import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;

public enum SendMode {
    IMMEDIATE,
    BATCHED;

    private static final Set<SendMode> IMMEDIATE_SET;
    private static final Set<SendMode> BATCHED_SET;
    private static final Set<SendMode> BATCHED_AND_IMMEDIATE_SET;

    public static SendMode fromString(String sendMode) {
        SendMode value = SendMode.valueOf(sendMode.trim().toUpperCase(Locale.US));
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("No SendMode associated with " + sendMode);
    }

    public static Set<SendMode> batchedSet() {
        return BATCHED_SET;
    }

    public static Set<SendMode> immediateSet() {
        return IMMEDIATE_SET;
    }

    public static Set<SendMode> batchedAndImmediateSet() {
        return BATCHED_AND_IMMEDIATE_SET;
    }

    static {
        IMMEDIATE_SET = ImmutableSet.of((Object)((Object)IMMEDIATE));
        BATCHED_SET = ImmutableSet.of((Object)((Object)BATCHED));
        BATCHED_AND_IMMEDIATE_SET = ImmutableSet.of((Object)((Object)BATCHED), (Object)((Object)IMMEDIATE));
    }
}

