/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.usersettings;

import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class SendSettings {
    private final SendMode sendMode;

    private SendSettings(Builder builder) {
        this.sendMode = builder.sendMode;
    }

    @Nonnull
    public SendMode getSendMode() {
        return this.sendMode;
    }

    public void applyTo(@Nonnull UserSettingsBuilder builder, @Nonnull String key) {
        builder.put(key, this.sendMode.name());
    }

    public static class Builder {
        private SendMode sendMode;

        @Nonnull
        public SendSettings build() {
            Objects.requireNonNull(this.sendMode, "sendMode");
            return new SendSettings(this);
        }

        @Nonnull
        public Builder sendMode(@Nonnull SendMode value) {
            this.sendMode = Objects.requireNonNull(value, "sendMode");
            return this;
        }
    }
}

