/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.usersettings;

import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.stash.internal.notification.rest.RestEmailNotificationSettings;
import com.atlassian.stash.internal.notification.rest.RestSendSettings;
import com.atlassian.stash.internal.notification.rest.RestUserNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.EmailNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.atlassian.stash.internal.notification.usersettings.SendSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettings;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class UserNotificationSettingsFactory {
    @Nonnull
    public static UserNotificationSettings create(@Nonnull RestUserNotificationSettings settings) {
        Objects.requireNonNull(settings, "settings");
        return new UserNotificationSettings.Builder().emailNotificationSettings(UserNotificationSettingsFactory.createEmailNotificationSettings(settings.getEmailNotificationSettings())).build();
    }

    @Nonnull
    public static UserNotificationSettings create(@Nonnull UserSettings settings, @Nonnull SendMode defaultSendMode) {
        Objects.requireNonNull(settings, "settings");
        Objects.requireNonNull(defaultSendMode, "defaultSendMode");
        return new UserNotificationSettings.Builder().emailNotificationSettings(UserNotificationSettingsFactory.createEmailNotificationSettings(settings, defaultSendMode)).build();
    }

    private static EmailNotificationSettings createEmailNotificationSettings(RestEmailNotificationSettings email) {
        if (email == null) {
            return null;
        }
        return new EmailNotificationSettings.Builder().repositorySendSettings(UserNotificationSettingsFactory.createSendSettings(email.getRepositoryNotifications())).pullRequestSendSettings(UserNotificationSettingsFactory.createSendSettings(email.getPullRequestNotifications())).build();
    }

    private static EmailNotificationSettings createEmailNotificationSettings(UserSettings settings, SendMode defaultSendMode) {
        return new EmailNotificationSettings.Builder().pullRequestSendSettings(UserNotificationSettingsFactory.createSendSettings(settings, UserNotificationSettingsFactory.getLegacySendMode(settings, defaultSendMode), "plugin.bitbucket-notification:notificationSendMode")).repositorySendSettings(UserNotificationSettingsFactory.createSendSettings(settings, defaultSendMode, "plugin.bitbucket-notification:email:repositoryNotificationSendMode")).build();
    }

    private static SendSettings createSendSettings(RestSendSettings sendSettings) {
        if (sendSettings == null || sendSettings.getSendMode() == null) {
            return null;
        }
        return new SendSettings.Builder().sendMode(sendSettings.getSendMode()).build();
    }

    private static SendSettings createSendSettings(UserSettings settings, SendMode defaultSendMode, String key) {
        SendMode sendMode = (SendMode)((Object)settings.getString(key).map(SendMode::fromString).getOrElse((Object)defaultSendMode));
        return new SendSettings.Builder().sendMode(sendMode).build();
    }

    private static SendMode getLegacySendMode(UserSettings settings, SendMode defaultSendMode) {
        return (SendMode)((Object)settings.getString("plugin.bitbucket-notification:notificationSendMode").orElse(() -> settings.getString("plugin.stash-notification:notificationSendMode")).map(SendMode::fromString).getOrElse((Object)defaultSendMode));
    }
}

